'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _enzyme = require('enzyme');

var _testHelpers = require('../ListBox/test-helpers');

var _DropdownV = require('../DropdownV2');

var _DropdownV2 = _interopRequireDefault(_DropdownV);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('DropdownV2', function () {
  var mockProps = void 0;
  beforeEach(function () {
    mockProps = {
      items: (0, _testHelpers.generateItems)(5, _testHelpers.generateGenericItem),
      onChange: jest.fn(),
      label: 'input',
      placeholder: 'Filter...',
      type: 'default'
    };
  });

  it('should render', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_DropdownV2.default, mockProps));
    expect(wrapper).toMatchSnapshot();
  });

  it('should initially render with the menu not open', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_DropdownV2.default, mockProps));
    (0, _testHelpers.assertMenuClosed)(wrapper);
  });

  it('should let the user open the menu by clicking on the control', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_DropdownV2.default, mockProps));
    (0, _testHelpers.openMenu)(wrapper);
    (0, _testHelpers.assertMenuOpen)(wrapper, mockProps);
  });

  it('should let the user select an option by clicking on the option node', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_DropdownV2.default, mockProps));
    (0, _testHelpers.openMenu)(wrapper);
    (0, _testHelpers.findMenuItemNode)(wrapper, 0).simulate('click');
    expect(mockProps.onChange).toHaveBeenCalledTimes(1);
    expect(mockProps.onChange).toHaveBeenCalledWith({
      selectedItem: mockProps.items[0]
    });
    (0, _testHelpers.assertMenuClosed)(wrapper);

    mockProps.onChange.mockClear();

    (0, _testHelpers.openMenu)(wrapper);
    (0, _testHelpers.findMenuItemNode)(wrapper, 1).simulate('click');
    expect(mockProps.onChange).toHaveBeenCalledTimes(1);
    expect(mockProps.onChange).toHaveBeenCalledWith({
      selectedItem: mockProps.items[1]
    });
  });
});