'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _addonActions = require('@storybook/addon-actions');

var _Notification = require('../Notification');

var _Notification2 = _interopRequireDefault(_Notification);

var _Link = require('../Link');

var _Link2 = _interopRequireDefault(_Link);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var notificationProps = {
  toast: {
    onCloseButtonClick: (0, _addonActions.action)('onCloseButtonClick'),
    className: 'some-class',
    title: 'Notification title',
    subtitle: 'Subtitle text goes here.',
    caption: 'Time stamp [00:00:00]',
    captionNode: _react2.default.createElement(
      _Link2.default,
      { href: '#' },
      'The caption can be any node.'
    ),
    iconDescription: 'describes the close button',
    style: { minWidth: '30rem', marginBottom: '.5rem' }
  },
  inline: {
    onCloseButtonClick: (0, _addonActions.action)('onCloseButtonClick'),
    className: 'some-class',
    title: 'Notification title',
    subtitle: 'Subtitle text goes here.',
    iconDescription: 'describes the close button'
  },
  subtitleNode: _react2.default.createElement(
    _Link2.default,
    { href: '#' },
    'The subtitle can be any node.'
  )
};

(0, _react3.storiesOf)('Notifications', module).addWithInfo('Deprecated: <Notfication />', '\n      Toast notifications are typically passive, meaning they won\'t affect the user\'s workflow if not addressed.\n      Toast Notifications use \'kind\' props to specify the kind of notification that should render (error, info, success, warning).\n    ', function () {
  return _react2.default.createElement(
    'div',
    null,
    _react2.default.createElement(_Notification2.default, _extends({}, notificationProps.toast, { kind: 'error' })),
    _react2.default.createElement(_Notification2.default, _extends({}, notificationProps.toast, { kind: 'info' })),
    _react2.default.createElement(_Notification2.default, _extends({}, notificationProps.toast, { kind: 'success' })),
    _react2.default.createElement(_Notification2.default, _extends({}, notificationProps.toast, { kind: 'warning' })),
    _react2.default.createElement(_Notification2.default, _extends({}, notificationProps.inline, { kind: 'error' })),
    _react2.default.createElement(_Notification2.default, _extends({}, notificationProps.inline, { kind: 'info' })),
    _react2.default.createElement(_Notification2.default, _extends({}, notificationProps.inline, { kind: 'success' })),
    _react2.default.createElement(_Notification2.default, _extends({}, notificationProps.inline, { kind: 'warning' }))
  );
}).addWithInfo('Toast', '\n  ...\n  ', function () {
  var toast = notificationProps.toast;

  return _react2.default.createElement(
    'div',
    null,
    _react2.default.createElement(_Notification.ToastNotification, _extends({}, toast, { kind: 'error' })),
    _react2.default.createElement(_Notification.ToastNotification, _extends({}, toast, { kind: 'info' })),
    _react2.default.createElement(_Notification.ToastNotification, _extends({}, toast, { kind: 'success' })),
    _react2.default.createElement(_Notification.ToastNotification, _extends({}, toast, { kind: 'warning' })),
    _react2.default.createElement(_Notification.ToastNotification, _extends({}, _extends({}, toast, {
      subtitle: notificationProps.subtitleNode,
      caption: toast.captionNode
    }), {
      kind: 'info'
    }))
  );
}).addWithInfo('inline', '\n  ...\n  ', function () {
  return _react2.default.createElement(
    'div',
    null,
    _react2.default.createElement(_Notification.InlineNotification, _extends({}, notificationProps.inline, { kind: 'error' })),
    _react2.default.createElement(_Notification.InlineNotification, _extends({}, notificationProps.inline, { kind: 'info' })),
    _react2.default.createElement(_Notification.InlineNotification, _extends({}, notificationProps.inline, { kind: 'success' })),
    _react2.default.createElement(_Notification.InlineNotification, _extends({}, notificationProps.inline, { kind: 'warning' })),
    _react2.default.createElement(_Notification.InlineNotification, _extends({}, _extends({}, notificationProps.inline, {
      subtitle: notificationProps.subtitleNode
    }), {
      kind: 'info'
    }))
  );
});