"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _Icon = _interopRequireDefault(require("../Icon"));

var _classnames = _interopRequireDefault(require("classnames"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

var NumberInput =
/*#__PURE__*/
function (_Component) {
  _inherits(NumberInput, _Component);

  /**
   * The DOM node refernce to the `<input>`.
   * @type {HTMLInputElement}
   */
  function NumberInput(props) {
    var _this;

    _classCallCheck(this, NumberInput);

    _this = _possibleConstructorReturn(this, (NumberInput.__proto__ || Object.getPrototypeOf(NumberInput)).call(this, props));

    _initialiseProps.call(_assertThisInitialized(_this));

    var value = props.value;

    if (props.min || props.min === 0) {
      value = Math.max(props.min, value);
    }

    _this.state = {
      value: value
    };
    return _this;
  }

  _createClass(NumberInput, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      if (nextProps.value !== this.props.value) {
        this.setState({
          value: nextProps.value
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          className = _props.className,
          disabled = _props.disabled,
          iconDescription = _props.iconDescription,
          id = _props.id,
          label = _props.label,
          max = _props.max,
          min = _props.min,
          step = _props.step,
          invalid = _props.invalid,
          invalidText = _props.invalidText,
          other = _objectWithoutProperties(_props, ["className", "disabled", "iconDescription", "id", "label", "max", "min", "step", "invalid", "invalidText"]);

      var numberInputClasses = (0, _classnames.default)('bx--number', className);
      var props = {
        disabled: disabled,
        id: id,
        max: max,
        min: min,
        step: step,
        onChange: this.handleChange,
        value: this.state.value
      };
      var buttonProps = {
        disabled: disabled,
        type: 'button',
        className: 'bx--number__control-btn'
      };
      var inputWrapperProps = {};
      var error = null;

      if (invalid || this.state.value === '') {
        inputWrapperProps['data-invalid'] = true;
        error = _react.default.createElement("div", {
          className: "bx--form-requirement"
        }, invalidText);
      }

      return _react.default.createElement("div", {
        className: "bx--form-item"
      }, _react.default.createElement("label", {
        htmlFor: id,
        className: "bx--label"
      }, label), _react.default.createElement("div", _extends({
        className: numberInputClasses
      }, inputWrapperProps), _react.default.createElement("input", _extends({
        type: "number",
        pattern: "[0-9]*"
      }, other, props, {
        ref: this._handleInputRef
      })), _react.default.createElement("div", {
        className: "bx--number__controls"
      }, _react.default.createElement("button", _extends({}, buttonProps, {
        onClick: function onClick(evt) {
          return _this2.handleArrowClick(evt, 'up');
        }
      }), _react.default.createElement(_Icon.default, {
        className: "up-icon",
        name: "caret--up",
        description: this.props.iconDescription,
        viewBox: "0 2 10 5"
      })), _react.default.createElement("button", _extends({}, buttonProps, {
        onClick: function onClick(evt) {
          return _this2.handleArrowClick(evt, 'down');
        }
      }), _react.default.createElement(_Icon.default, {
        className: "down-icon",
        name: "caret--down",
        viewBox: "0 2 10 5",
        description: this.props.iconDescription
      })))), error);
    }
  }]);

  return NumberInput;
}(_react.Component);

exports.default = NumberInput;
Object.defineProperty(NumberInput, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    className: _propTypes.default.string,
    disabled: _propTypes.default.bool,
    iconDescription: _propTypes.default.string.isRequired,
    id: _propTypes.default.string.isRequired,
    label: _propTypes.default.node,
    max: _propTypes.default.number,
    min: _propTypes.default.number,

    /**
     * The new value is available in 'imaginaryTarget.value'
     * i.e. to get the value: evt.imaginaryTarget.value
     */
    onChange: _propTypes.default.func,
    onClick: _propTypes.default.func,
    step: _propTypes.default.number,
    value: _propTypes.default.number,
    invalid: _propTypes.default.bool,
    invalidText: _propTypes.default.string
  }
});
Object.defineProperty(NumberInput, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    disabled: false,
    iconDescription: 'choose a number',
    label: ' ',
    onChange: function onChange() {},
    onClick: function onClick() {},
    step: 1,
    value: 0,
    invalid: false,
    invalidText: 'Provide invalidText'
  }
});

var _initialiseProps = function _initialiseProps() {
  var _this3 = this;

  Object.defineProperty(this, "_inputRef", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: null
  });
  Object.defineProperty(this, "handleChange", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value(evt) {
      if (!_this3.props.disabled) {
        evt.persist();
        evt.imaginaryTarget = _this3._inputRef;

        _this3.setState({
          value: evt.target.value
        }, function () {
          _this3.props.onChange(evt);
        });
      }
    }
  });
  Object.defineProperty(this, "handleArrowClick", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value(evt, direction) {
      var value = typeof _this3.state.value === 'string' ? Number(_this3.state.value) : _this3.state.value;
      var _this3$props = _this3.props,
          disabled = _this3$props.disabled,
          min = _this3$props.min,
          max = _this3$props.max,
          step = _this3$props.step;
      var conditional = direction === 'down' ? min !== undefined && value > min || min === undefined : max !== undefined && value < max || max === undefined;

      if (!disabled && conditional) {
        value = direction === 'down' ? value - step : value + step;
        evt.persist();
        evt.imaginaryTarget = _this3._inputRef;

        _this3.setState({
          value: value
        }, function () {
          _this3.props.onClick(evt, direction);

          _this3.props.onChange(evt, direction);
        });
      }
    }
  });
  Object.defineProperty(this, "_handleInputRef", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value(ref) {
      _this3._inputRef = ref;
    }
  });
};