'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _OrderSummary = require('../OrderSummary');

var _Dropdown = require('../Dropdown');

var _Dropdown2 = _interopRequireDefault(_Dropdown);

var _DropdownItem = require('../DropdownItem');

var _DropdownItem2 = _interopRequireDefault(_DropdownItem);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('OrderSummaryHeader', function () {
  describe('Renders as expected', function () {
    var orderSummaryHeader = (0, _enzyme.mount)(_react2.default.createElement(
      _OrderSummary.OrderSummaryHeader,
      { className: 'some-class', title: 'Order Summary' },
      _react2.default.createElement(
        _Dropdown2.default,
        { defaultText: 'USD' },
        _react2.default.createElement(_DropdownItem2.default, { itemText: 'USD', value: 'usd' }),
        _react2.default.createElement(_DropdownItem2.default, { itemText: 'GBP', value: 'gbp' }),
        _react2.default.createElement(_DropdownItem2.default, { itemText: 'NOK', value: 'nok' }),
        _react2.default.createElement(_DropdownItem2.default, { itemText: 'EUR', value: 'eur' })
      )
    ));

    it('renders Order Summary Header', function () {
      expect(orderSummaryHeader.length).toEqual(1);
    });

    it('should render with the appropriate classes', function () {
      expect(orderSummaryHeader.children().hasClass('bx--order-header')).toEqual(true);
      expect(orderSummaryHeader.children().hasClass('some-class')).toEqual(true);
    });

    it('should render with the correct title', function () {
      expect(orderSummaryHeader.find('.bx--order-header-title').text()).toEqual('Order Summary');
    });

    it('should render children as expected', function () {
      expect(orderSummaryHeader.find(_Dropdown2.default).length).toEqual(1);
    });
  });
});