'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Icon = require('../Icon');

var _Icon2 = _interopRequireDefault(_Icon);

var _Select = require('../Select');

var _Select2 = _interopRequireDefault(_Select);

var _SelectItem = require('../SelectItem');

var _SelectItem2 = _interopRequireDefault(_SelectItem);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Select', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _Select2.default,
      { id: 'testing', labelText: 'Select', className: 'extra-class' },
      _react2.default.createElement(_SelectItem2.default, null),
      _react2.default.createElement(_SelectItem2.default, null)
    ));

    var selectContainer = wrapper.find('.bx--form-item > div');
    var label = wrapper.find('label');
    var select = wrapper.find('select');

    describe('selectContainer', function () {
      it('renders a container', function () {
        expect(selectContainer.length).toEqual(1);
      });

      it('renders the down arrow icon', function () {
        expect(selectContainer.find(_Icon2.default).length).toEqual(1);
      });

      it('should use correct icon', function () {
        var icon = wrapper.find(_Icon2.default);
        expect(icon.props().name).toEqual('caret--down');
      });

      it('has the expected classes', function () {
        expect(selectContainer.hasClass('bx--select')).toEqual(true);
      });

      it('applies extra classes specified via className', function () {
        expect(selectContainer.hasClass('extra-class')).toEqual(true);
      });

      it('has the expected default iconDescription', function () {
        expect(wrapper.props().iconDescription).toEqual('open list of options');
      });

      it('adds new iconDescription when passed via props', function () {
        wrapper.setProps({ iconDescription: 'new description' });
        expect(wrapper.props().iconDescription).toEqual('new description');
      });

      it('should have iconDescription match Icon component description prop', function () {
        var matches = wrapper.props().iconDescription === wrapper.find(_Icon2.default).props().description;
        expect(matches).toEqual(true);
      });
    });

    describe('select', function () {
      it('renders a select', function () {
        expect(select.length).toEqual(1);
      });

      it('has the expected classes', function () {
        expect(select.hasClass('bx--select-input')).toEqual(true);
      });

      it('has the expected id', function () {
        expect(select.props().id).toEqual('testing');
      });

      it('should set defaultValue as expected', function () {
        wrapper.setProps({ defaultValue: 'select-1' });
        expect(wrapper.find('select').props().defaultValue).toEqual('select-1');
      });

      it('should set disabled as expected', function () {
        expect(select.props().disabled).toEqual(false);
        wrapper.setProps({ disabled: true });
        expect(wrapper.find('select').props().disabled).toEqual(true);
      });

      it('renders children as expected', function () {
        expect(select.props().children.length).toEqual(2);
      });
    });

    describe('label', function () {
      it('renders a label', function () {
        expect(label.length).toEqual(1);
      });

      it('has the expected classes', function () {
        expect(label.hasClass('bx--label')).toEqual(true);
      });

      it('has the expected htmlFor value', function () {
        expect(label.props().htmlFor).toEqual('testing');
      });

      it('renders children as expected', function () {
        expect(label.props().children).toEqual('Select');
      });
    });
  });
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _Select2.default,
      { id: 'testing', labelText: 'Select', className: 'extra-class', inline: true },
      _react2.default.createElement(_SelectItem2.default, null),
      _react2.default.createElement(_SelectItem2.default, null)
    ));

    var selectContainer = wrapper.find('.bx--form-item > div');

    it('has the expected classes', function () {
      expect(selectContainer.hasClass('bx--select--inline')).toEqual(true);
    });
  });
});