"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Tab =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Tab, _React$Component);

  function Tab() {
    _classCallCheck(this, Tab);

    return _possibleConstructorReturn(this, (Tab.__proto__ || Object.getPrototypeOf(Tab)).apply(this, arguments));
  }

  _createClass(Tab, [{
    key: "setTabFocus",
    value: function setTabFocus(evt) {
      var leftKey = 37;
      var rightKey = 39;

      if (evt.which === leftKey) {
        this.props.handleTabAnchorFocus(this.props.index - 1);
      } else if (evt.which === rightKey) {
        this.props.handleTabAnchorFocus(this.props.index + 1);
      } else {
        return;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _props = this.props,
          className = _props.className,
          handleTabClick = _props.handleTabClick,
          handleTabAnchorFocus = _props.handleTabAnchorFocus,
          handleTabKeyDown = _props.handleTabKeyDown,
          href = _props.href,
          index = _props.index,
          label = _props.label,
          selected = _props.selected,
          tabIndex = _props.tabIndex,
          _onClick = _props.onClick,
          _onKeyDown = _props.onKeyDown,
          renderAnchor = _props.renderAnchor,
          other = _objectWithoutProperties(_props, ["className", "handleTabClick", "handleTabAnchorFocus", "handleTabKeyDown", "href", "index", "label", "selected", "tabIndex", "onClick", "onKeyDown", "renderAnchor"]);

      var classes = (0, _classnames.default)('bx--tabs__nav-item', {
        'bx--tabs__nav-item--selected': selected
      }, className);
      var anchorProps = {
        className: 'bx--tabs__nav-link',
        href: href,
        role: 'tab',
        tabIndex: tabIndex,
        ref: function ref(e) {
          _this.tabAnchor = e;
        }
      };
      return _react.default.createElement("li", _extends({}, other, {
        tabIndex: -1,
        className: classes,
        onClick: function onClick(evt) {
          handleTabClick(index, label, evt);

          _onClick(evt);
        },
        onKeyDown: function onKeyDown(evt) {
          _this.setTabFocus(evt);

          handleTabKeyDown(index, label, evt);

          _onKeyDown(evt);
        },
        role: "presentation",
        selected: selected
      }), renderAnchor ? renderAnchor(anchorProps) : _react.default.createElement("a", anchorProps, label));
    }
  }]);

  return Tab;
}(_react.default.Component);

exports.default = Tab;
Object.defineProperty(Tab, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    className: _propTypes.default.string,
    handleTabClick: _propTypes.default.func,
    handleTabAnchorFocus: _propTypes.default.func,
    handleTabKeyDown: _propTypes.default.func,
    href: _propTypes.default.string.isRequired,
    index: _propTypes.default.number,
    label: _propTypes.default.string,
    role: _propTypes.default.string.isRequired,
    onClick: _propTypes.default.func.isRequired,
    onKeyDown: _propTypes.default.func.isRequired,
    selected: _propTypes.default.bool.isRequired,
    tabIndex: _propTypes.default.number.isRequired,

    /*
     * An optional parameter to allow overriding the anchor rendering.
     * Useful for using Tab along with react-router or other client
     * side router libraries.
     **/
    renderAnchor: _propTypes.default.func
  }
});
Object.defineProperty(Tab, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    role: 'presentation',
    label: 'provide a label',
    tabIndex: 0,
    href: '#',
    selected: false,
    onClick: function onClick() {},
    onKeyDown: function onKeyDown() {}
  }
});