'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _Table = require('../Table');

var _Table2 = _interopRequireDefault(_Table);

var _TableHead = require('../TableHead');

var _TableHead2 = _interopRequireDefault(_TableHead);

var _TableHeader = require('../TableHeader');

var _TableHeader2 = _interopRequireDefault(_TableHeader);

var _TableBody = require('../TableBody');

var _TableBody2 = _interopRequireDefault(_TableBody);

var _TableRow = require('../TableRow');

var _TableRow2 = _interopRequireDefault(_TableRow);

var _TableRowExpanded = require('../TableRowExpanded');

var _TableRowExpanded2 = _interopRequireDefault(_TableRowExpanded);

var _TableData = require('../TableData');

var _TableData2 = _interopRequireDefault(_TableData);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var NestedTable = function (_Component) {
  _inherits(NestedTable, _Component);

  function NestedTable() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, NestedTable);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = NestedTable.__proto__ || Object.getPrototypeOf(NestedTable)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      toggle: []
    }, _this.toggleRow = function (index) {
      var toggle = _this.state.toggle;
      toggle[index] = toggle[index] ? !toggle[index] : true;
      _this.setState({
        toggle: toggle
      });
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(NestedTable, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var data = [['Harry', 'Potter', 'Gryffindor'], ['Hermoine', 'Granger', 'Slytherin!?'], ['Jon', 'Snow', 'Stark']];

      var relatedData = [_react2.default.createElement(
        'p',
        null,
        'The main character in Harry Potter'
      ), _react2.default.createElement(
        'p',
        null,
        'The other main character'
      ), _react2.default.createElement(
        _Table2.default,
        null,
        _react2.default.createElement(
          _TableHead2.default,
          null,
          _react2.default.createElement(
            _TableRow2.default,
            { header: true },
            _react2.default.createElement(
              _TableHeader2.default,
              null,
              'First Name'
            ),
            _react2.default.createElement(
              _TableHeader2.default,
              null,
              'Last Name'
            ),
            _react2.default.createElement(
              _TableHeader2.default,
              null,
              'House'
            )
          )
        ),
        _react2.default.createElement(
          _TableBody2.default,
          null,
          _react2.default.createElement(
            _TableRow2.default,
            null,
            _react2.default.createElement(
              _TableData2.default,
              null,
              'Harry'
            ),
            _react2.default.createElement(
              _TableData2.default,
              null,
              'Potter'
            ),
            _react2.default.createElement(
              _TableData2.default,
              null,
              'Gryffindor'
            )
          )
        )
      )];

      var rowData = data.map(function (character, index) {
        var toggleState = _this2.state.toggle[index] ? _this2.state.toggle[index] : false;
        var charArray = character.map(function (trait, charIndex) {
          return _react2.default.createElement(
            _TableData2.default,
            { key: 'd' + charIndex },
            trait
          );
        });
        return [_react2.default.createElement(_TableData2.default, {
          onClick: function onClick() {
            return _this2.toggleRow(index);
          },
          key: 'a' + index,
          expanded: toggleState
        })].concat(_toConsumableArray(charArray));
      });

      var createRows = rowData.map(function (row, index) {
        return _react2.default.createElement(
          _TableRow2.default,
          { key: 'b' + index },
          row
        );
      });

      var createExpandedRows = relatedData.map(function (row, index) {
        var toggleState = _this2.state.toggle[index] ? _this2.state.toggle[index] : false;
        return _react2.default.createElement(
          _TableRowExpanded2.default,
          { expanded: toggleState, colSpan: 4, key: 'c' + index },
          row
        );
      });

      var createTableBody = createRows.map(function (character, index) {
        return [character, createExpandedRows[index]];
      });

      return _react2.default.createElement(
        _Table2.default,
        null,
        _react2.default.createElement(
          _TableHead2.default,
          null,
          _react2.default.createElement(
            _TableRow2.default,
            { header: true },
            _react2.default.createElement(_TableHeader2.default, null),
            _react2.default.createElement(
              _TableHeader2.default,
              null,
              'First Name'
            ),
            _react2.default.createElement(
              _TableHeader2.default,
              null,
              'Last Name'
            ),
            _react2.default.createElement(
              _TableHeader2.default,
              null,
              'House'
            )
          )
        ),
        _react2.default.createElement(
          _TableBody2.default,
          null,
          createTableBody
        )
      );
    }
  }]);

  return NestedTable;
}(_react.Component);

(0, _react3.storiesOf)('Table', module).addWithInfo('Simple Table', '\n      The Table component is the data-table implementation of blueix-components.\n      Create a table using Table, TableHead, Table Row, TableHeader, and TableBody. Each component maps to their HTML counterpart,\n      wrapped with carbon components styles.\n\n      Table doesn\'t do data-fetch for you or height/width calculations, it auto-fills it\n      to the native HTML spec. Any overrides you want to do can be passed in via props.\n    ', function () {
  return _react2.default.createElement(
    _Table2.default,
    null,
    _react2.default.createElement(
      _TableHead2.default,
      null,
      _react2.default.createElement(
        _TableRow2.default,
        { header: true },
        _react2.default.createElement(
          _TableHeader2.default,
          null,
          'First Name'
        ),
        _react2.default.createElement(
          _TableHeader2.default,
          null,
          'Last Name'
        ),
        _react2.default.createElement(
          _TableHeader2.default,
          null,
          'House'
        )
      )
    ),
    _react2.default.createElement(
      _TableBody2.default,
      null,
      _react2.default.createElement(
        _TableRow2.default,
        null,
        _react2.default.createElement(
          _TableData2.default,
          null,
          'Harry'
        ),
        _react2.default.createElement(
          _TableData2.default,
          null,
          'Potter'
        ),
        _react2.default.createElement(
          _TableData2.default,
          null,
          'Gryffindor'
        )
      ),
      _react2.default.createElement(
        _TableRow2.default,
        null,
        _react2.default.createElement(
          _TableData2.default,
          null,
          'Hermoine'
        ),
        _react2.default.createElement(
          _TableData2.default,
          null,
          'Granger'
        ),
        _react2.default.createElement(
          _TableData2.default,
          null,
          'Gryffindor'
        )
      ),
      _react2.default.createElement(
        _TableRow2.default,
        null,
        _react2.default.createElement(
          _TableData2.default,
          null,
          'Blaise'
        ),
        _react2.default.createElement(
          _TableData2.default,
          null,
          'Zambini'
        ),
        _react2.default.createElement(
          _TableData2.default,
          null,
          'Slytherin'
        )
      ),
      _react2.default.createElement(
        _TableRow2.default,
        null,
        _react2.default.createElement(
          _TableData2.default,
          null,
          'Jon'
        ),
        _react2.default.createElement(
          _TableData2.default,
          null,
          'Snow'
        ),
        _react2.default.createElement(
          _TableData2.default,
          null,
          'Stark'
        )
      )
    )
  );
}).addWithInfo('Nested Table', '\n      Nested table shows the expansion capabilities of the basic tables. Note that\n      this functionality is driven (like most of our components) through your application\n      altering props on the elements\n    ', function () {
  return _react2.default.createElement(NestedTable, null);
});