'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Toggle = require('../Toggle');

var _Toggle2 = _interopRequireDefault(_Toggle);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Toggle', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Toggle2.default, { id: 'toggle-1' }));

    var input = wrapper.find('input');

    it('Switch and label Ids should match', function () {
      var toggleLabel = wrapper.find('.bx--toggle__label');
      expect(input.id).toEqual(toggleLabel.htmlFor);
    });

    it('should set defaultChecked as expected', function () {
      expect(input.props().defaultChecked).toEqual(false);
      wrapper.setProps({ defaultToggled: true });
      expect(wrapper.find('input').props().defaultChecked).toEqual(true);
    });

    it('Can set defaultToggled state', function () {
      wrapper.setProps({ defaultToggled: true });
      expect(wrapper.find('.bx--toggle').props().defaultChecked).toEqual(true);
    });

    it('Should add extra classes that are passed via className', function () {
      wrapper.setProps({ className: 'extra-class' });
      expect(wrapper.find('div').hasClass('extra-class')).toEqual(true);
    });

    it('Can be disabled', function () {
      wrapper.setProps({ disabled: true });
      expect(wrapper.find('.bx--toggle').props().disabled).toEqual(true);
    });

    it('Can have a labelA', function () {
      wrapper.setProps({ labelA: 'labelA-test' });
      expect(wrapper.find('.bx--toggle__text--left').text()).toEqual('labelA-test');
    });

    it('Can have a labelB', function () {
      wrapper.setProps({ labelB: 'labelB-test' });
      expect(wrapper.find('.bx--toggle__text--right').text()).toEqual('labelB-test');
    });
  });

  it('toggled prop sets checked prop on input', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Toggle2.default, { id: 'test', toggled: true }));

    var input = function input() {
      return wrapper.find('input');
    };
    expect(input().props().checked).toEqual(true);

    wrapper.setProps({ toggled: false });
    expect(input().props().checked).toEqual(false);
  });

  describe('events', function () {
    it('should invoke onToggle with expected arguments', function () {
      var onToggle = jest.fn();
      var id = 'test-input';
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Toggle2.default, { id: id, onToggle: onToggle }));

      var input = wrapper.find('input');
      var inputElement = input.instance();

      inputElement.checked = true;
      wrapper.find('input').simulate('change');

      var call = onToggle.mock.calls[0];

      expect(call[0]).toEqual(true);
      expect(call[1]).toEqual(id);
      expect(call[2].target).toBe(inputElement);
    });
  });
});