'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _Tooltip = require('../Tooltip');

var _Tooltip2 = _interopRequireDefault(_Tooltip);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _react3.storiesOf)('Tooltip', module).addWithInfo('default (bottom)', '\n      Tooltips are used to supply additional information to an element when hovering over it. By default,\n      the tooltip will render above the element. The example below shows the default scenario.\n    ', function () {
  return _react2.default.createElement(
    'div',
    { style: { marginTop: '2rem' } },
    _react2.default.createElement(
      _Tooltip2.default,
      { triggerText: 'Tooltip label' },
      _react2.default.createElement(
        'p',
        { className: 'bx--tooltip__label' },
        'Tooltip subtitle'
      ),
      _react2.default.createElement(
        'p',
        null,
        'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaeca cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.'
      )
    )
  );
}).addWithInfo('position - top', '\n        Tooltips are used to supply additional information to an element when hovering over it. By default,\n        the tooltip will render above the element. The example below shows specifying the position (supports \'bottom\' and \'top\')\n      ', function () {
  return _react2.default.createElement(
    'div',
    { style: { marginTop: '2rem' } },
    _react2.default.createElement(
      _Tooltip2.default,
      { triggerText: 'Tooltip - top', direction: 'top' },
      _react2.default.createElement(
        'p',
        { className: 'bx--tooltip__label' },
        'Tooltip subtitle'
      ),
      _react2.default.createElement(
        'p',
        null,
        'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaeca cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.'
      )
    )
  );
}).addWithInfo('position - right', '\n      Tooltips are used to supply additional information to an element when hovering over it. By default,\n      the tooltip will render above the element. The example below shows specifying the position (supports \'bottom\' and \'top\')\n    ', function () {
  return _react2.default.createElement(
    'div',
    { style: { marginTop: '2rem' } },
    _react2.default.createElement(
      _Tooltip2.default,
      { triggerText: 'Tooltip - right', direction: 'right' },
      _react2.default.createElement(
        'p',
        { className: 'bx--tooltip__label' },
        'Tooltip subtitle'
      ),
      _react2.default.createElement(
        'p',
        null,
        'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaeca cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.'
      )
    )
  );
}).addWithInfo('position - left', '\n      Tooltips are used to supply additional information to an element when hovering over it. By default,\n      the tooltip will render above the element. The example below shows specifying the position (supports \'bottom\' and \'top\')\n    ', function () {
  return _react2.default.createElement(
    'div',
    { style: { marginTop: '2rem' } },
    _react2.default.createElement(
      _Tooltip2.default,
      { triggerText: 'Tooltip - left', direction: 'left' },
      _react2.default.createElement(
        'p',
        { className: 'bx--tooltip__label' },
        'Tooltip subtitle'
      ),
      _react2.default.createElement(
        'p',
        null,
        'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaeca cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.'
      )
    )
  );
}).addWithInfo('no icon - bottom (default)', '\n      Tooltips are used to supply additional information to an element when hovering over it. By default,\n      the tooltip will render with an information Icon. The example below shows the option to exclude the Icon.\n    ', function () {
  return _react2.default.createElement(
    'div',
    { style: { marginTop: '2rem' } },
    _react2.default.createElement(
      _Tooltip2.default,
      {
        triggerText: 'Tooltip - no icon - bottom (default)',
        showIcon: false },
      _react2.default.createElement(
        'p',
        { className: 'bx--tooltip__label' },
        'Tooltip subtitle'
      ),
      _react2.default.createElement(
        'p',
        null,
        'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaeca cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.'
      )
    )
  );
}).addWithInfo('no icon - right', '\n      Tooltips are used to supply additional information to an element when hovering over it. By default,\n      the tooltip will render with an information Icon. The example below shows the option to exclude the Icon.\n    ', function () {
  return _react2.default.createElement(
    'div',
    { style: { marginTop: '2rem' } },
    _react2.default.createElement(
      _Tooltip2.default,
      {
        triggerText: 'Tooltip - no icon - right',
        direction: 'right',
        showIcon: false },
      _react2.default.createElement(
        'p',
        { className: 'bx--tooltip__label' },
        'Tooltip subtitle'
      ),
      _react2.default.createElement(
        'p',
        null,
        'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaeca cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.'
      )
    )
  );
}).addWithInfo('no icon - left', '\n      Tooltips are used to supply additional information to an element when hovering over it. By default,\n      the tooltip will render with an information Icon. The example below shows the option to exclude the Icon.\n    ', function () {
  return _react2.default.createElement(
    'div',
    { style: { marginTop: '2rem' } },
    _react2.default.createElement(
      _Tooltip2.default,
      {
        triggerText: 'Tooltip - no icon - left',
        direction: 'left',
        showIcon: false,
        menuOffset: { left: 8 } },
      '>',
      _react2.default.createElement(
        'p',
        { className: 'bx--tooltip__label' },
        'Tooltip subtitle'
      ),
      _react2.default.createElement(
        'p',
        null,
        'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaeca cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.'
      )
    )
  );
}).addWithInfo('click to open', '\n      Tooltips are used to supply additional information to an element when hovering over it. The example\n      below shows the option to open on click instead of hover, which is useful when including interactive\n      elements such as links inside the tooltip.\n    ', function () {
  return _react2.default.createElement(
    'div',
    { style: { marginTop: '2rem' } },
    _react2.default.createElement(
      _Tooltip2.default,
      { clickToOpen: true, triggerText: 'Tooltip label' },
      _react2.default.createElement(
        'p',
        { className: 'bx--tooltip__label' },
        'Tooltip with link'
      ),
      _react2.default.createElement(
        'a',
        { href: 'http://react.carbondesignsystem.com/', target: '_blank' },
        'Visit Carbon React'
      )
    )
  );
});