'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Icon = require('../Icon');

var _Icon2 = _interopRequireDefault(_Icon);

var _FloatingMenu = require('../../internal/FloatingMenu');

var _FloatingMenu2 = _interopRequireDefault(_FloatingMenu);

var _Tooltip = require('../Tooltip');

var _Tooltip2 = _interopRequireDefault(_Tooltip);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Tooltip', function () {
  describe('Renders as expected with defaults', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _Tooltip2.default,
      { triggerText: 'Tooltip' },
      _react2.default.createElement(
        'p',
        { className: 'bx--tooltip__label' },
        'Tooltip label'
      ),
      _react2.default.createElement(
        'p',
        null,
        'Lorem ipsum dolor sit amet'
      )
    ));

    var trigger = wrapper.find('.bx--tooltip__trigger');

    describe('tooltip trigger', function () {
      it('renders a tooltip container', function () {
        expect(trigger.length).toEqual(1);
      });

      it('renders the info icon', function () {
        var icon = trigger.find(_Icon2.default);
        expect(icon.length).toBe(1);
        expect(icon.props().name).toBe('info--glyph');
      });
    });
  });

  describe('Renders as expected with specified properties', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _Tooltip2.default,
      {
        triggerText: 'Tooltip',
        direction: 'bottom',
        menuOffset: { left: 10, top: 15 },
        showIcon: false },
      ' ',
      _react2.default.createElement(
        'p',
        { className: 'bx--tooltip__label' },
        'Tooltip label'
      ),
      _react2.default.createElement(
        'p',
        null,
        'Lorem ipsum dolor sit amet'
      )
    ));

    var trigger = wrapper.find('.bx--tooltip__trigger');
    var floatingMenu = wrapper.find(_FloatingMenu2.default);

    describe('tooltip container', function () {
      it("sets the tooltip's position", function () {
        expect(floatingMenu.prop('menuDirection')).toEqual('bottom');
      });
      it("sets the tooltip's offset", function () {
        expect(floatingMenu.prop('menuOffset')).toEqual({ left: 10, top: 15 });
      });
      it('does not render info icon', function () {
        var icon = trigger.find(_Icon2.default);
        expect(icon.exists()).toBe(false);
      });
    });
  });

  describe('events', function () {
    it('hover changes state with icon', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Tooltip2.default, { triggerText: 'Tooltip' }));
      var icon = wrapper.find(_Icon2.default);
      icon.simulate('mouseover');
      expect(wrapper.state().open).toEqual(true);
      icon.simulate('mouseout');
      expect(wrapper.state().open).toEqual(false);
    });

    it('focus/blur changes state with icon', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Tooltip2.default, { triggerText: 'Tooltip' }));
      var icon = wrapper.find(_Icon2.default);
      icon.simulate('focus');
      expect(wrapper.state().open).toEqual(true);
      icon.simulate('blur');
      expect(wrapper.state().open).toEqual(false);
    });

    it('hover changes state with no icon', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Tooltip2.default, { showIcon: false, triggerText: 'Tooltip' }));
      var trigger = wrapper.find('.bx--tooltip__trigger');
      trigger.simulate('mouseover');
      expect(wrapper.state().open).toEqual(true);
      trigger.simulate('mouseout');
      expect(wrapper.state().open).toEqual(false);
    });

    it('focus/blur changes state with no icon', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Tooltip2.default, { showIcon: false, triggerText: 'Tooltip' }));
      var trigger = wrapper.find('.bx--tooltip__trigger');
      trigger.simulate('focus');
      expect(wrapper.state().open).toEqual(true);
      trigger.simulate('blur');
      expect(wrapper.state().open).toEqual(false);
    });

    it('click changes state when clickToOpen is set', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Tooltip2.default, { clickToOpen: true, triggerText: 'Tooltip' }));
      var icon = wrapper.find(_Icon2.default);
      icon.simulate('click');
      expect(wrapper.state().open).toEqual(true);
      icon.simulate('click');
      expect(wrapper.state().open).toEqual(false);
    });

    it('hover does not change state when clickToOpen is set', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Tooltip2.default, { clickToOpen: true, triggerText: 'Tooltip' }));
      var icon = wrapper.find(_Icon2.default);
      icon.simulate('mouseover');
      expect(wrapper.state().open).toEqual(false);
      icon.simulate('mouseout');
      expect(wrapper.state().open).toEqual(false);
    });

    it('Enter key press changes state when clickToOpen is set', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Tooltip2.default, { clickToOpen: true, triggerText: 'Tooltip' }));
      var icon = wrapper.find(_Icon2.default);
      icon.simulate('keyDown', { which: 'Enter' });
      expect(wrapper.state().open).toEqual(true);
      icon.simulate('keyDown', { key: 13 });
      expect(wrapper.state().open).toEqual(false);
    });

    it('Space key press changes state when clickToOpen is set', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Tooltip2.default, { clickToOpen: true, triggerText: 'Tooltip' }));
      var icon = wrapper.find(_Icon2.default);
      icon.simulate('keyDown', { which: ' ' });
      expect(wrapper.state().open).toEqual(true);
      icon.simulate('keyDown', { key: 32 });
      expect(wrapper.state().open).toEqual(false);
    });

    it('A different key press does not change state', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Tooltip2.default, { clickToOpen: true, triggerText: 'Tooltip' }));
      var icon = wrapper.find(_Icon2.default);
      icon.simulate('keyDown', { which: 'x' });
      expect(wrapper.state().open).toEqual(false);
    });

    it('should be in a closed state after handleOutsideClick() is invoked', function () {
      var rootWrapper = (0, _enzyme.mount)(_react2.default.createElement(_Tooltip2.default, { clickToOpen: true, triggerText: 'Tooltip' }));
      expect(rootWrapper.state().open).toEqual(false);
      rootWrapper.setState({ open: true });
      rootWrapper.instance().handleClickOutside();
      expect(rootWrapper.state().open).toEqual(false);
    });
  });

  describe('getTriggerPosition', function () {
    it('sets triggerPosition when triggerEl is set', function () {
      var rootWrapper = (0, _enzyme.mount)(_react2.default.createElement(_Tooltip2.default, { clickToOpen: true, triggerText: 'Tooltip' }));
      rootWrapper.setState({ triggerPosition: 'test' });
      rootWrapper.instance().getTriggerPosition();
      expect(rootWrapper.state().triggerPosition).not.toEqual('test');
    });
    it('does not set triggerPosition when triggerEl is not set', function () {
      var rootWrapper = (0, _enzyme.mount)(_react2.default.createElement(_Tooltip2.default, { clickToOpen: true, triggerText: 'Tooltip' }));
      rootWrapper.setState({ triggerPosition: 'test' });
      delete rootWrapper.instance().triggerEl;
      rootWrapper.instance().getTriggerPosition();
      expect(rootWrapper.state().triggerPosition).toEqual('test');
    });
  });
});