'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _UnorderedList = require('../UnorderedList');

var _UnorderedList2 = _interopRequireDefault(_UnorderedList);

var _ListItem = require('../ListItem');

var _ListItem2 = _interopRequireDefault(_ListItem);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('UnorderedList', function () {
  describe('Renders as expected', function () {
    var list = (0, _enzyme.shallow)(_react2.default.createElement(
      _UnorderedList2.default,
      { className: 'some-class' },
      _react2.default.createElement(
        _ListItem2.default,
        null,
        'Item'
      )
    ));

    it('should be a ul element', function () {
      expect(list.find('ul').length).toEqual(1);
    });

    it('should render with the appropriate classes', function () {
      expect(list.hasClass('bx--list--unordered')).toEqual(true);
      expect(list.hasClass('some-class')).toEqual(true);
    });

    it('should render children as expected', function () {
      expect(list.find(_ListItem2.default).length).toEqual(1);
    });

    it('should render nested lists', function () {
      list.setProps({ nested: true });
      expect(list.hasClass('bx--list--nested')).toEqual(true);
      list.setProps({ nested: false });
      expect(list.hasClass('bx--list--nested')).toEqual(false);
    });
  });
});