var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import mixin from '../../globals/js/misc/mixin';
import createComponent from '../../globals/js/mixins/create-component';
import initComponentBySearch from '../../globals/js/mixins/init-component-by-search';
import handles from '../../globals/js/mixins/handles';
import on from '../../globals/js/misc/on';

var stateChangeTypes = {
  true: 'true',
  false: 'false',
  mixed: 'mixed'
};

var Checkbox = function (_mixin) {
  _inherits(Checkbox, _mixin);

  /**
   * Checkbox UI.
   * @extends CreateComponent
   * @extends InitComponentBySearch
   * @extends Handles
   * @param {HTMLElement} element The element working as a checkbox UI.
   */

  function Checkbox(element, options) {
    _classCallCheck(this, Checkbox);

    var _this = _possibleConstructorReturn(this, (Checkbox.__proto__ || Object.getPrototypeOf(Checkbox)).call(this, element, options));

    _this.manage(on(_this.element, 'click', function (event) {
      _this._handleClick(event);
    }));
    _this.manage(on(_this.element, 'focus', function (event) {
      _this._handleFocus(event);
    }));
    _this.manage(on(_this.element, 'blur', function (event) {
      _this._handleBlur(event);
    }));

    _this._indeterminateCheckbox();
    _this._initCheckbox();
    return _this;
  }

  _createClass(Checkbox, [{
    key: '_handleClick',
    value: function _handleClick() {
      if (this.element.checked === true) {
        this.element.setAttribute('checked', '');
        this.element.setAttribute('aria-checked', 'true');
        this.element.checked = true;

        // nested checkboxes inside labels
        if (this.element.parentElement.classList.contains('bx--checkbox-label')) {
          this.element.parentElement.setAttribute('data-contained-checkbox-state', 'true');
        }
      } else if (this.element.checked === false) {
        this.element.removeAttribute('checked');
        this.element.setAttribute('aria-checked', 'false');
        this.element.checked = false;

        // nested checkboxes inside labels
        if (this.element.parentElement.classList.contains('bx--checkbox-label')) {
          this.element.parentElement.setAttribute('data-contained-checkbox-state', 'false');
        }
      }
    }
  }, {
    key: '_handleFocus',
    value: function _handleFocus() {
      if (this.element.parentElement.classList.contains('bx--checkbox-label')) {
        this.element.parentElement.classList.add('bx--checkbox-label__focus');
      }
    }
  }, {
    key: '_handleBlur',
    value: function _handleBlur() {
      if (this.element.parentElement.classList.contains('bx--checkbox-label')) {
        this.element.parentElement.classList.remove('bx--checkbox-label__focus');
      }
    }

    /**
     * Sets the new checkbox state.
     * @param {boolean|string} [state]
     *   The new checkbox state to set. `mixed` to put checkbox in indeterminate state.
     *   If omitted, this method simply makes the style reflect `aria-checked` attribute.
     */

  }, {
    key: 'setState',
    value: function setState(state) {
      if (state === undefined || stateChangeTypes[state] === undefined) {
        throw new TypeError('setState expects a value of true, false or mixed.');
      }

      this.element.setAttribute('aria-checked', state);
      this.element.indeterminate = state === stateChangeTypes.mixed;
      this.element.checked = state === stateChangeTypes.true;

      var container = this.element.closest('[data-contained-checkbox-state]');
      if (container) {
        container.setAttribute('data-contained-checkbox-state', state);
      }
    }
  }, {
    key: 'setDisabled',
    value: function setDisabled(value) {
      if (value === undefined) {
        throw new TypeError('setDisabled expects a boolean value of true or false');
      }
      if (value === true) {
        this.element.setAttribute('disabled', true);
      } else if (value === false) {
        this.element.removeAttribute('disabled');
      }
      var container = this.element.closest('[data-contained-checkbox-disabled]');
      if (container) {
        container.setAttribute('data-contained-checkbox-disabled', value);
      }
    }
  }, {
    key: '_indeterminateCheckbox',
    value: function _indeterminateCheckbox() {
      if (this.element.getAttribute('aria-checked') === 'mixed') {
        this.element.indeterminate = true;
      }
      if (this.element.indeterminate === true) {
        this.element.setAttribute('aria-checked', 'mixed');
      }
      if (this.element.parentElement.classList.contains('bx--checkbox-label') && this.element.indeterminate === true) {
        this.element.parentElement.setAttribute('data-contained-checkbox-state', 'mixed');
      }
    }
  }, {
    key: '_initCheckbox',
    value: function _initCheckbox() {
      if (this.element.checked === true) {
        this.element.setAttribute('aria-checked', 'true');
      }
      if (this.element.parentElement.classList.contains('bx--checkbox-label') && this.element.checked) {
        this.element.parentElement.setAttribute('data-contained-checkbox-state', 'true');
      }
      if (this.element.parentElement.classList.contains('bx--checkbox-label')) {
        this.element.parentElement.setAttribute('data-contained-checkbox-disabled', 'false');
      }
      if (this.element.parentElement.classList.contains('bx--checkbox-label') && this.element.disabled) {
        this.element.parentElement.setAttribute('data-contained-checkbox-disabled', 'true');
      }
    }

    /**
     * The map associating DOM element and copy button UI instance.
     * @member Checkbox.components
     * @type {WeakMap}
     */


    /**
     * The component options.
     * If `options` is specified in the constructor, {@linkcode Checkbox.create .create()}, or {@linkcode Checkbox.init .init()},
     * properties in this object are overriden for the instance being create and how {@linkcode Checkbox.init .init()} works.
     * @member Checkbox.options
     * @type {Object}
     * @property {string} selectorInit The data attribute to find copy button UIs.
     */

  }]);

  return Checkbox;
}(mixin(createComponent, initComponentBySearch, handles));

Checkbox.components = new WeakMap();
Checkbox.options = {
  selectorInit: '.bx--checkbox'
};
Checkbox.stateChangeTypes = stateChangeTypes;


export default Checkbox;