module.exports = {
  directives: {
    'base-uri': { type: 'sourceList' },
    'block-all-mixed-content': { type: 'boolean' },
    'child-src': { type: 'sourceList' },
    'connect-src': { type: 'sourceList' },
    'default-src': {
      type: 'sourceList',
      hasStrictDynamic: true
    },
    'font-src': { type: 'sourceList' },
    'form-action': { type: 'sourceList' },
    'frame-ancestors': { type: 'sourceList' },
    'frame-src': { type: 'sourceList' },
    'img-src': { type: 'sourceList' },
    'manifest-src': { type: 'sourceList' },
    'media-src': { type: 'sourceList' },
    'object-src': { type: 'sourceList' },
    'script-src': {
      type: 'sourceList',
      hasUnsafes: true,
      hasStrictDynamic: true
    },
    'style-src': {
      type: 'sourceList',
      hasUnsafes: true
    },
    'prefetch-src': { type: 'sourceList' },
    'plugin-types': { type: 'pluginTypes' },
    sandbox: { type: 'sandbox' },
    'report-to': { type: 'reportUri' },
    'report-uri': { type: 'reportUri' },
    'require-sri-for': { type: 'requireSriFor' },
    'upgrade-insecure-requests': { type: 'boolean' },
    'worker-src': {
      type: 'sourceList',
      hasUnsafes: true
    }
  },
  allHeaders: [
    'Content-Security-Policy',
    'X-Content-Security-Policy',
    'X-WebKit-CSP'
  ],
  mustQuote: ['none', 'self', 'unsafe-inline', 'unsafe-eval', 'strict-dynamic'],
  unsafes: ["'unsafe-inline'", 'unsafe-inline', "'unsafe-eval'", 'unsafe-eval'],
  strictDynamics: ["'strict-dynamic'", 'strict-dynamic'],
  requireSriForValues: ['script', 'style'],
  sandboxDirectives: [
    'allow-downloads-without-user-activation',
    'allow-forms',
    'allow-modals',
    'allow-orientation-lock',
    'allow-pointer-lock',
    'allow-popups',
    'allow-popups-to-escape-sandbox',
    'allow-presentation',
    'allow-same-origin',
    'allow-scripts',
    'allow-top-navigation'
  ]
}
