'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    var ownKeys = Object.keys(source);

    if (typeof Object.getOwnPropertySymbols === 'function') {
      ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
        return Object.getOwnPropertyDescriptor(source, sym).enumerable;
      }));
    }

    ownKeys.forEach(function (key) {
      _defineProperty(target, key, source[key]);
    });
  }

  return target;
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};

  var target = _objectWithoutPropertiesLoose(source, excluded);

  var key, i;

  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }

  return target;
}

/**
 * Copyright IBM Corp. 2018, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var defaultAttributes = {
  // Reference:
  // https://github.com/IBM/carbon-components-react/issues/1392
  // https://github.com/PolymerElements/iron-iconset-svg/pull/47
  // `focusable` is a string attribute which is why we do not use a boolean here
  focusable: 'false',
  preserveAspectRatio: 'xMidYMid meet',
  // Reference:
  // https://github.com/ckeditor/ckeditor5/issues/668#issuecomment-344844027
  style: 'will-change: transform;'
};
/**
 * Get supplementary HTML attributes for a given <svg> element based on existing
 * attributes.
 */

function getAttributes() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      width = _ref.width,
      height = _ref.height,
      _ref$viewBox = _ref.viewBox,
      viewBox = _ref$viewBox === void 0 ? "0 0 ".concat(width, " ").concat(height) : _ref$viewBox,
      attributes = _objectWithoutProperties(_ref, ["width", "height", "viewBox"]);

  var tabindex = attributes.tabindex,
      rest = _objectWithoutProperties(attributes, ["tabindex"]);

  var iconAttributes = _objectSpread({}, defaultAttributes, rest, {
    width: width,
    height: height,
    viewBox: viewBox
  }); // TODO: attributes.title assumes that the consumer will implement <title> and
  // correctly set `aria-labelledby`.


  if (iconAttributes['aria-label'] || iconAttributes['aria-labelledby'] || iconAttributes.title) {
    iconAttributes.role = 'img'; // Reference:
    // https://allyjs.io/tutorials/focusing-in-svg.html

    if (tabindex !== undefined && tabindex !== null) {
      iconAttributes.focusable = 'true';
      iconAttributes.tabindex = tabindex;
    }
  } else {
    iconAttributes['aria-hidden'] = true;
  }

  return iconAttributes;
}

/**
 * Copyright IBM Corp. 2018, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Convert an icon descriptor to a String
 */

function toString(descriptor) {
  var _descriptor$elem = descriptor.elem,
      elem = _descriptor$elem === void 0 ? 'svg' : _descriptor$elem,
      _descriptor$attrs = descriptor.attrs,
      attrs = _descriptor$attrs === void 0 ? {} : _descriptor$attrs,
      _descriptor$content = descriptor.content,
      content = _descriptor$content === void 0 ? [] : _descriptor$content;
  var children = content.map(toString).join('');

  if (elem !== 'svg') {
    return "<".concat(elem, " ").concat(formatAttributes(attrs), ">").concat(children, "</").concat(elem, ">");
  }

  return "<".concat(elem, " ").concat(formatAttributes(getAttributes(attrs)), ">").concat(children, "</").concat(elem, ">");
}
function formatAttributes(attrs) {
  return Object.keys(attrs).reduce(function (acc, key, index) {
    var attribute = "".concat(key, "=\"").concat(attrs[key], "\"");

    if (index === 0) {
      return attribute;
    }

    return acc + ' ' + attribute;
  }, '');
}

/**
 * Copyright IBM Corp. 2018, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Convert an icon descriptor to a DOM node.
 */

function toSVG(descriptor) {
  var _descriptor$elem = descriptor.elem,
      elem = _descriptor$elem === void 0 ? 'svg' : _descriptor$elem,
      _descriptor$attrs = descriptor.attrs,
      attrs = _descriptor$attrs === void 0 ? {} : _descriptor$attrs,
      _descriptor$content = descriptor.content,
      content = _descriptor$content === void 0 ? [] : _descriptor$content;
  var node = document.createElementNS('http://www.w3.org/2000/svg', elem);
  var attributes = elem !== 'svg' ? attrs : getAttributes(attrs);
  Object.keys(attributes).forEach(function (key) {
    node.setAttribute(key, attrs[key]);
  });

  for (var i = 0; i < content.length; i++) {
    node.appendChild(toSVG(content[i]));
  }

  return node;
}

/**
 * Copyright IBM Corp. 2018, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

exports.defaultAttributes = defaultAttributes;
exports.getAttributes = getAttributes;
exports.formatAttributes = formatAttributes;
exports.toString = toString;
exports.toSVG = toSVG;
