(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "@apollo/react-common", "tslib", "react", "apollo-client", "@wry/equality", "ts-invariant"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("@apollo/react-common"), require("tslib"), require("react"), require("apollo-client"), require("@wry/equality"), require("ts-invariant"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.reactCommon, global.tslib, global.react, global.apolloClient, global.equality, global.tsInvariant);
    global.unknown = mod.exports;
  }
})(this, function (_exports, _reactCommon, _tslib, _react, _apolloClient, _equality, _tsInvariant) {

  _exports.__esModule = true;
  _exports.useApolloClient = useApolloClient;
  _exports.useLazyQuery = useLazyQuery;
  _exports.useMutation = useMutation;
  _exports.useQuery = useQuery;
  _exports.useSubscription = useSubscription;
  _exports.RenderPromises = _exports.resetApolloContext = _exports.ApolloProvider = _exports.ApolloConsumer = void 0;
  _exports.getApolloContext = _reactCommon.getApolloContext;
  _exports.ApolloConsumer = _reactCommon.ApolloConsumer;
  _exports.ApolloProvider = _reactCommon.ApolloProvider;
  _exports.resetApolloContext = _reactCommon.resetApolloContext;
  _react = _interopRequireWildcard(_react);

  function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

  function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

  var OperationData = function () {
    function OperationData(options, context) {
      this.isMounted = false;
      this.previousOptions = {};
      this.context = {};
      this.options = {};
      this.options = options || {};
      this.context = context || {};
    }

    OperationData.prototype.getOptions = function () {
      return this.options;
    };

    OperationData.prototype.setOptions = function (newOptions, storePrevious) {
      if (storePrevious === void 0) {
        storePrevious = false;
      }

      if (storePrevious && !(0, _equality.equal)(this.options, newOptions)) {
        this.previousOptions = this.options;
      }

      this.options = newOptions;
    };

    OperationData.prototype.unmount = function () {
      this.isMounted = false;
    };

    OperationData.prototype.refreshClient = function () {
      var client = this.options && this.options.client || this.context && this.context.client;
      process.env.NODE_ENV === "production" ? (0, _tsInvariant.invariant)(!!client, 2) : (0, _tsInvariant.invariant)(!!client, 'Could not find "client" in the context or passed in as an option. ' + 'Wrap the root component in an <ApolloProvider>, or pass an ' + 'ApolloClient instance in via options.');
      var isNew = false;

      if (client !== this.client) {
        isNew = true;
        this.client = client;
        this.cleanup();
      }

      return {
        client: this.client,
        isNew: isNew
      };
    };

    OperationData.prototype.verifyDocumentType = function (document, type) {
      var operation = (0, _reactCommon.parser)(document);
      var requiredOperationName = (0, _reactCommon.operationName)(type);
      var usedOperationName = (0, _reactCommon.operationName)(operation.type);
      process.env.NODE_ENV === "production" ? (0, _tsInvariant.invariant)(operation.type === type, 3) : (0, _tsInvariant.invariant)(operation.type === type, "Running a " + requiredOperationName + " requires a graphql " + (requiredOperationName + ", but a " + usedOperationName + " was used instead."));
    };

    return OperationData;
  }();

  var QueryData = function (_super) {
    (0, _tslib.__extends)(QueryData, _super);

    function QueryData(_a) {
      var options = _a.options,
          context = _a.context,
          onNewData = _a.onNewData;

      var _this = _super.call(this, options, context) || this;

      _this.previousData = {};
      _this.currentObservable = {};
      _this.runLazy = false;

      _this.runLazyQuery = function (options) {
        _this.cleanup();

        _this.runLazy = true;
        _this.lazyOptions = options;

        _this.onNewData();
      };

      _this.getExecuteResult = function () {
        var result = _this.getQueryResult();

        _this.startQuerySubscription();

        return result;
      };

      _this.obsRefetch = function (variables) {
        return _this.currentObservable.query.refetch(variables);
      };

      _this.obsFetchMore = function (fetchMoreOptions) {
        return _this.currentObservable.query.fetchMore(fetchMoreOptions);
      };

      _this.obsUpdateQuery = function (mapFn) {
        return _this.currentObservable.query.updateQuery(mapFn);
      };

      _this.obsStartPolling = function (pollInterval) {
        _this.currentObservable && _this.currentObservable.query && _this.currentObservable.query.startPolling(pollInterval);
      };

      _this.obsStopPolling = function () {
        _this.currentObservable && _this.currentObservable.query && _this.currentObservable.query.stopPolling();
      };

      _this.obsSubscribeToMore = function (options) {
        return _this.currentObservable.query.subscribeToMore(options);
      };

      _this.onNewData = onNewData;
      return _this;
    }

    QueryData.prototype.execute = function () {
      this.refreshClient();

      var _a = this.getOptions(),
          skip = _a.skip,
          query = _a.query;

      if (skip || query !== this.previousData.query) {
        this.removeQuerySubscription();
        this.previousData.query = query;
      }

      this.updateObservableQuery();
      if (this.isMounted) this.startQuerySubscription();
      return this.getExecuteSsrResult() || this.getExecuteResult();
    };

    QueryData.prototype.executeLazy = function () {
      return !this.runLazy ? [this.runLazyQuery, {
        loading: false,
        networkStatus: _apolloClient.NetworkStatus.ready,
        called: false,
        data: undefined
      }] : [this.runLazyQuery, this.execute()];
    };

    QueryData.prototype.fetchData = function () {
      var options = this.getOptions();
      if (options.skip || options.ssr === false) return false;
      var obs = this.currentObservable.query;
      var currentResult = obs.getCurrentResult();
      return currentResult.loading ? obs.result() : false;
    };

    QueryData.prototype.afterExecute = function (_a) {
      var _b = (_a === void 0 ? {} : _a).lazy,
          lazy = _b === void 0 ? false : _b;
      this.isMounted = true;

      if (!lazy || this.runLazy) {
        this.handleErrorOrCompleted();
      }

      this.previousOptions = this.getOptions();
      return this.unmount.bind(this);
    };

    QueryData.prototype.cleanup = function () {
      this.removeQuerySubscription();
      delete this.currentObservable.query;
      delete this.previousData.result;
    };

    QueryData.prototype.getOptions = function () {
      var options = _super.prototype.getOptions.call(this);

      if (this.lazyOptions) {
        options.variables = (0, _tslib.__assign)((0, _tslib.__assign)({}, options.variables), this.lazyOptions.variables);
        options.context = (0, _tslib.__assign)((0, _tslib.__assign)({}, options.context), this.lazyOptions.context);
      }

      if (this.runLazy) {
        delete options.skip;
      }

      return options;
    };

    QueryData.prototype.ssrInitiated = function () {
      return this.context && this.context.renderPromises;
    };

    QueryData.prototype.getExecuteSsrResult = function () {
      var ssrDisabled = this.getOptions().ssr === false;
      var fetchDisabled = this.refreshClient().client.disableNetworkFetches;
      var ssrLoading = (0, _tslib.__assign)({
        loading: true,
        networkStatus: _apolloClient.NetworkStatus.loading,
        called: true,
        data: undefined,
        stale: false,
        client: this.client
      }, this.observableQueryFields());

      if (ssrDisabled && (this.ssrInitiated() || fetchDisabled)) {
        this.previousData.result = ssrLoading;
        return ssrLoading;
      }

      var result;

      if (this.ssrInitiated()) {
        result = this.context.renderPromises.addQueryPromise(this, this.getExecuteResult) || ssrLoading;
      }

      return result;
    };

    QueryData.prototype.prepareObservableQueryOptions = function () {
      var options = this.getOptions();
      this.verifyDocumentType(options.query, _reactCommon.DocumentType.Query);
      var displayName = options.displayName || 'Query';

      if (this.ssrInitiated() && (options.fetchPolicy === 'network-only' || options.fetchPolicy === 'cache-and-network')) {
        options.fetchPolicy = 'cache-first';
      }

      return (0, _tslib.__assign)((0, _tslib.__assign)({}, options), {
        displayName: displayName,
        context: options.context,
        metadata: {
          reactComponent: {
            displayName: displayName
          }
        }
      });
    };

    QueryData.prototype.initializeObservableQuery = function () {
      var _a, _b;

      if (this.ssrInitiated()) {
        this.currentObservable.query = this.context.renderPromises.getSSRObservable(this.getOptions());
      }

      if (!this.currentObservable.query) {
        var observableQueryOptions = this.prepareObservableQueryOptions();
        this.previousData.observableQueryOptions = (0, _tslib.__assign)((0, _tslib.__assign)({}, observableQueryOptions), {
          children: null
        });
        this.currentObservable.query = this.refreshClient().client.watchQuery((0, _tslib.__assign)({}, observableQueryOptions));

        if (this.ssrInitiated()) {
          (_b = (_a = this.context) === null || _a === void 0 ? void 0 : _a.renderPromises) === null || _b === void 0 ? void 0 : _b.registerSSRObservable(this.currentObservable.query, observableQueryOptions);
        }
      }
    };

    QueryData.prototype.updateObservableQuery = function () {
      if (!this.currentObservable.query) {
        this.initializeObservableQuery();
        return;
      }

      var newObservableQueryOptions = (0, _tslib.__assign)((0, _tslib.__assign)({}, this.prepareObservableQueryOptions()), {
        children: null
      });

      if (!(0, _equality.equal)(newObservableQueryOptions, this.previousData.observableQueryOptions)) {
        this.previousData.observableQueryOptions = newObservableQueryOptions;
        this.currentObservable.query.setOptions(newObservableQueryOptions).catch(function () {});
      }
    };

    QueryData.prototype.startQuerySubscription = function () {
      var _this = this;

      if (this.currentObservable.subscription || this.getOptions().skip) return;
      var obsQuery = this.currentObservable.query;
      this.currentObservable.subscription = obsQuery.subscribe({
        next: function (_a) {
          var loading = _a.loading,
              networkStatus = _a.networkStatus,
              data = _a.data;
          var previousResult = _this.previousData.result;

          if (previousResult && previousResult.loading === loading && previousResult.networkStatus === networkStatus && (0, _equality.equal)(previousResult.data, data)) {
            return;
          }

          _this.onNewData();
        },
        error: function (error) {
          _this.resubscribeToQuery();

          if (!error.hasOwnProperty('graphQLErrors')) throw error;
          var previousResult = _this.previousData.result;

          if (previousResult && previousResult.loading || !(0, _equality.equal)(error, _this.previousData.error)) {
            _this.previousData.error = error;

            _this.onNewData();
          }
        }
      });
    };

    QueryData.prototype.resubscribeToQuery = function () {
      this.removeQuerySubscription();
      var lastError = this.currentObservable.query.getLastError();
      var lastResult = this.currentObservable.query.getLastResult();
      this.currentObservable.query.resetLastResults();
      this.startQuerySubscription();
      Object.assign(this.currentObservable.query, {
        lastError: lastError,
        lastResult: lastResult
      });
    };

    QueryData.prototype.getQueryResult = function () {
      var result = this.observableQueryFields();
      var options = this.getOptions();

      if (options.skip) {
        result = (0, _tslib.__assign)((0, _tslib.__assign)({}, result), {
          data: undefined,
          error: undefined,
          loading: false,
          called: true
        });
      } else {
        var currentResult = this.currentObservable.query.getCurrentResult();
        var loading = currentResult.loading,
            partial = currentResult.partial,
            networkStatus = currentResult.networkStatus,
            errors = currentResult.errors;
        var error = currentResult.error,
            data = currentResult.data;

        if (errors && errors.length > 0) {
          error = new _apolloClient.ApolloError({
            graphQLErrors: errors
          });
        }

        result = (0, _tslib.__assign)((0, _tslib.__assign)({}, result), {
          loading: loading,
          networkStatus: networkStatus,
          error: error,
          called: true
        });

        if (loading) {
          var previousData = this.previousData.result && this.previousData.result.data;
          result.data = previousData && data ? (0, _tslib.__assign)((0, _tslib.__assign)({}, previousData), data) : previousData || data;
        } else if (error) {
          Object.assign(result, {
            data: (this.currentObservable.query.getLastResult() || {}).data
          });
        } else {
          var fetchPolicy = this.currentObservable.query.options.fetchPolicy;
          var partialRefetch = options.partialRefetch;

          if (partialRefetch && !data && partial && fetchPolicy !== 'cache-only') {
            Object.assign(result, {
              loading: true,
              networkStatus: _apolloClient.NetworkStatus.loading
            });
            result.refetch();
            return result;
          }

          result.data = data;
        }
      }

      result.client = this.client;
      this.previousData.loading = this.previousData.result && this.previousData.result.loading || false;
      this.previousData.result = result;
      this.currentObservable.query && this.currentObservable.query.resetQueryStoreErrors();
      return result;
    };

    QueryData.prototype.handleErrorOrCompleted = function () {
      var obsQuery = this.currentObservable.query;
      if (!obsQuery || !this.previousData.result) return;
      var _a = this.previousData.result,
          data = _a.data,
          loading = _a.loading,
          error = _a.error;

      if (!loading) {
        var _b = this.getOptions(),
            query = _b.query,
            variables = _b.variables,
            onCompleted = _b.onCompleted,
            onError = _b.onError;

        if (this.previousOptions && !this.previousData.loading && (0, _equality.equal)(this.previousOptions.query, query) && (0, _equality.equal)(this.previousOptions.variables, variables)) {
          return;
        }

        if (onCompleted && !error) {
          onCompleted(data);
        } else if (onError && error) {
          onError(error);
        }
      }
    };

    QueryData.prototype.removeQuerySubscription = function () {
      if (this.currentObservable.subscription) {
        this.currentObservable.subscription.unsubscribe();
        delete this.currentObservable.subscription;
      }
    };

    QueryData.prototype.observableQueryFields = function () {
      var observable = this.currentObservable.query;
      return {
        variables: observable.variables,
        refetch: this.obsRefetch,
        fetchMore: this.obsFetchMore,
        updateQuery: this.obsUpdateQuery,
        startPolling: this.obsStartPolling,
        stopPolling: this.obsStopPolling,
        subscribeToMore: this.obsSubscribeToMore
      };
    };

    return QueryData;
  }(OperationData);

  function useDeepMemo(memoFn, key) {
    var ref = (0, _react.useRef)();

    if (!ref.current || !(0, _equality.equal)(key, ref.current.key)) {
      ref.current = {
        key: key,
        value: memoFn()
      };
    }

    return ref.current.value;
  }

  function useBaseQuery(query, options, lazy) {
    if (lazy === void 0) {
      lazy = false;
    }

    var context = (0, _react.useContext)((0, _reactCommon.getApolloContext)());

    var _a = (0, _react.useReducer)(function (x) {
      return x + 1;
    }, 0),
        tick = _a[0],
        forceUpdate = _a[1];

    var updatedOptions = options ? (0, _tslib.__assign)((0, _tslib.__assign)({}, options), {
      query: query
    }) : {
      query: query
    };
    var queryDataRef = (0, _react.useRef)();
    var queryData = queryDataRef.current || new QueryData({
      options: updatedOptions,
      context: context,
      onNewData: function () {
        if (!queryData.ssrInitiated()) {
          Promise.resolve().then(forceUpdate);
        } else {
          forceUpdate();
        }
      }
    });
    queryData.setOptions(updatedOptions);
    queryData.context = context;

    if (queryData.ssrInitiated() && !queryDataRef.current) {
      queryDataRef.current = queryData;
    }

    var memo = {
      options: (0, _tslib.__assign)((0, _tslib.__assign)({}, updatedOptions), {
        onError: undefined,
        onCompleted: undefined
      }),
      context: context,
      tick: tick
    };
    var result = useDeepMemo(function () {
      return lazy ? queryData.executeLazy() : queryData.execute();
    }, memo);
    var queryResult = lazy ? result[1] : result;
    (0, _react.useEffect)(function () {
      if (!queryDataRef.current) {
        queryDataRef.current = queryData;
      }

      return function () {
        return queryData.cleanup();
      };
    }, []);
    (0, _react.useEffect)(function () {
      return queryData.afterExecute({
        lazy: lazy
      });
    }, [queryResult.loading, queryResult.networkStatus, queryResult.error, queryResult.data]);
    return result;
  }

  function useQuery(query, options) {
    return useBaseQuery(query, options, false);
  }

  function useLazyQuery(query, options) {
    return useBaseQuery(query, options, true);
  }

  var MutationData = function (_super) {
    (0, _tslib.__extends)(MutationData, _super);

    function MutationData(_a) {
      var options = _a.options,
          context = _a.context,
          result = _a.result,
          setResult = _a.setResult;

      var _this = _super.call(this, options, context) || this;

      _this.runMutation = function (mutationFunctionOptions) {
        if (mutationFunctionOptions === void 0) {
          mutationFunctionOptions = {};
        }

        _this.onMutationStart();

        var mutationId = _this.generateNewMutationId();

        return _this.mutate(mutationFunctionOptions).then(function (response) {
          _this.onMutationCompleted(response, mutationId);

          return response;
        }).catch(function (error) {
          _this.onMutationError(error, mutationId);

          if (!_this.getOptions().onError) throw error;
        });
      };

      _this.verifyDocumentType(options.mutation, _reactCommon.DocumentType.Mutation);

      _this.result = result;
      _this.setResult = setResult;
      _this.mostRecentMutationId = 0;
      return _this;
    }

    MutationData.prototype.execute = function (result) {
      this.isMounted = true;
      this.verifyDocumentType(this.getOptions().mutation, _reactCommon.DocumentType.Mutation);
      result.client = this.refreshClient().client;
      return [this.runMutation, result];
    };

    MutationData.prototype.afterExecute = function () {
      this.isMounted = true;
      return this.unmount.bind(this);
    };

    MutationData.prototype.cleanup = function () {};

    MutationData.prototype.mutate = function (mutationFunctionOptions) {
      var _a = this.getOptions(),
          mutation = _a.mutation,
          variables = _a.variables,
          optimisticResponse = _a.optimisticResponse,
          update = _a.update,
          _b = _a.context,
          mutationContext = _b === void 0 ? {} : _b,
          _c = _a.awaitRefetchQueries,
          awaitRefetchQueries = _c === void 0 ? false : _c,
          fetchPolicy = _a.fetchPolicy;

      var mutateOptions = (0, _tslib.__assign)({}, mutationFunctionOptions);
      var mutateVariables = Object.assign({}, variables, mutateOptions.variables);
      delete mutateOptions.variables;
      return this.refreshClient().client.mutate((0, _tslib.__assign)({
        mutation: mutation,
        optimisticResponse: optimisticResponse,
        refetchQueries: mutateOptions.refetchQueries || this.getOptions().refetchQueries,
        awaitRefetchQueries: awaitRefetchQueries,
        update: update,
        context: mutationContext,
        fetchPolicy: fetchPolicy,
        variables: mutateVariables
      }, mutateOptions));
    };

    MutationData.prototype.onMutationStart = function () {
      if (!this.result.loading && !this.getOptions().ignoreResults) {
        this.updateResult({
          loading: true,
          error: undefined,
          data: undefined,
          called: true
        });
      }
    };

    MutationData.prototype.onMutationCompleted = function (response, mutationId) {
      var _a = this.getOptions(),
          onCompleted = _a.onCompleted,
          ignoreResults = _a.ignoreResults;

      var data = response.data,
          errors = response.errors;
      var error = errors && errors.length > 0 ? new _apolloClient.ApolloError({
        graphQLErrors: errors
      }) : undefined;

      var callOncomplete = function () {
        return onCompleted ? onCompleted(data) : null;
      };

      if (this.isMostRecentMutation(mutationId) && !ignoreResults) {
        this.updateResult({
          called: true,
          loading: false,
          data: data,
          error: error
        });
      }

      callOncomplete();
    };

    MutationData.prototype.onMutationError = function (error, mutationId) {
      var onError = this.getOptions().onError;

      if (this.isMostRecentMutation(mutationId)) {
        this.updateResult({
          loading: false,
          error: error,
          data: undefined,
          called: true
        });
      }

      if (onError) {
        onError(error);
      }
    };

    MutationData.prototype.generateNewMutationId = function () {
      return ++this.mostRecentMutationId;
    };

    MutationData.prototype.isMostRecentMutation = function (mutationId) {
      return this.mostRecentMutationId === mutationId;
    };

    MutationData.prototype.updateResult = function (result) {
      if (this.isMounted && (!this.previousResult || !(0, _equality.equal)(this.previousResult, result))) {
        this.setResult(result);
        this.previousResult = result;
      }
    };

    return MutationData;
  }(OperationData);

  function useMutation(mutation, options) {
    var context = (0, _react.useContext)((0, _reactCommon.getApolloContext)());

    var _a = (0, _react.useState)({
      called: false,
      loading: false
    }),
        result = _a[0],
        setResult = _a[1];

    var updatedOptions = options ? (0, _tslib.__assign)((0, _tslib.__assign)({}, options), {
      mutation: mutation
    }) : {
      mutation: mutation
    };
    var mutationDataRef = (0, _react.useRef)();

    function getMutationDataRef() {
      if (!mutationDataRef.current) {
        mutationDataRef.current = new MutationData({
          options: updatedOptions,
          context: context,
          result: result,
          setResult: setResult
        });
      }

      return mutationDataRef.current;
    }

    var mutationData = getMutationDataRef();
    mutationData.setOptions(updatedOptions);
    mutationData.context = context;
    (0, _react.useEffect)(function () {
      return mutationData.afterExecute();
    });
    return mutationData.execute(result);
  }

  var SubscriptionData = function (_super) {
    (0, _tslib.__extends)(SubscriptionData, _super);

    function SubscriptionData(_a) {
      var options = _a.options,
          context = _a.context,
          setResult = _a.setResult;

      var _this = _super.call(this, options, context) || this;

      _this.currentObservable = {};
      _this.setResult = setResult;

      _this.initialize(options);

      return _this;
    }

    SubscriptionData.prototype.execute = function (result) {
      if (this.getOptions().skip === true) {
        this.cleanup();
        return {
          loading: false,
          error: undefined,
          data: undefined,
          variables: this.getOptions().variables
        };
      }

      var currentResult = result;

      if (this.refreshClient().isNew) {
        currentResult = this.getLoadingResult();
      }

      var shouldResubscribe = this.getOptions().shouldResubscribe;

      if (typeof shouldResubscribe === 'function') {
        shouldResubscribe = !!shouldResubscribe(this.getOptions());
      }

      if (shouldResubscribe !== false && this.previousOptions && Object.keys(this.previousOptions).length > 0 && (this.previousOptions.subscription !== this.getOptions().subscription || !(0, _equality.equal)(this.previousOptions.variables, this.getOptions().variables) || this.previousOptions.skip !== this.getOptions().skip)) {
        this.cleanup();
        currentResult = this.getLoadingResult();
      }

      this.initialize(this.getOptions());
      this.startSubscription();
      this.previousOptions = this.getOptions();
      return (0, _tslib.__assign)((0, _tslib.__assign)({}, currentResult), {
        variables: this.getOptions().variables
      });
    };

    SubscriptionData.prototype.afterExecute = function () {
      this.isMounted = true;
    };

    SubscriptionData.prototype.cleanup = function () {
      this.endSubscription();
      delete this.currentObservable.query;
    };

    SubscriptionData.prototype.initialize = function (options) {
      if (this.currentObservable.query || this.getOptions().skip === true) return;
      this.currentObservable.query = this.refreshClient().client.subscribe({
        query: options.subscription,
        variables: options.variables,
        fetchPolicy: options.fetchPolicy
      });
    };

    SubscriptionData.prototype.startSubscription = function () {
      if (this.currentObservable.subscription) return;
      this.currentObservable.subscription = this.currentObservable.query.subscribe({
        next: this.updateCurrentData.bind(this),
        error: this.updateError.bind(this),
        complete: this.completeSubscription.bind(this)
      });
    };

    SubscriptionData.prototype.getLoadingResult = function () {
      return {
        loading: true,
        error: undefined,
        data: undefined
      };
    };

    SubscriptionData.prototype.updateResult = function (result) {
      if (this.isMounted) {
        this.setResult(result);
      }
    };

    SubscriptionData.prototype.updateCurrentData = function (result) {
      var onSubscriptionData = this.getOptions().onSubscriptionData;
      this.updateResult({
        data: result.data,
        loading: false,
        error: undefined
      });

      if (onSubscriptionData) {
        onSubscriptionData({
          client: this.refreshClient().client,
          subscriptionData: result
        });
      }
    };

    SubscriptionData.prototype.updateError = function (error) {
      this.updateResult({
        error: error,
        loading: false
      });
    };

    SubscriptionData.prototype.completeSubscription = function () {
      var onSubscriptionComplete = this.getOptions().onSubscriptionComplete;
      if (onSubscriptionComplete) onSubscriptionComplete();
      this.endSubscription();
    };

    SubscriptionData.prototype.endSubscription = function () {
      if (this.currentObservable.subscription) {
        this.currentObservable.subscription.unsubscribe();
        delete this.currentObservable.subscription;
      }
    };

    return SubscriptionData;
  }(OperationData);

  function useSubscription(subscription, options) {
    var context = (0, _react.useContext)((0, _reactCommon.getApolloContext)());
    var updatedOptions = options ? (0, _tslib.__assign)((0, _tslib.__assign)({}, options), {
      subscription: subscription
    }) : {
      subscription: subscription
    };

    var _a = (0, _react.useState)({
      loading: !updatedOptions.skip,
      error: undefined,
      data: undefined
    }),
        result = _a[0],
        setResult = _a[1];

    var subscriptionDataRef = (0, _react.useRef)();

    function getSubscriptionDataRef() {
      if (!subscriptionDataRef.current) {
        subscriptionDataRef.current = new SubscriptionData({
          options: updatedOptions,
          context: context,
          setResult: setResult
        });
      }

      return subscriptionDataRef.current;
    }

    var subscriptionData = getSubscriptionDataRef();
    subscriptionData.setOptions(updatedOptions, true);
    subscriptionData.context = context;
    (0, _react.useEffect)(function () {
      return subscriptionData.afterExecute();
    });
    (0, _react.useEffect)(function () {
      return subscriptionData.cleanup.bind(subscriptionData);
    }, []);
    return subscriptionData.execute(result);
  }

  function useApolloClient() {
    var client = _react.default.useContext((0, _reactCommon.getApolloContext)()).client;

    process.env.NODE_ENV === "production" ? (0, _tsInvariant.invariant)(client, 1) : (0, _tsInvariant.invariant)(client, 'No Apollo Client instance can be found. Please ensure that you ' + 'have called `ApolloProvider` higher up in your tree.');
    return client;
  }

  function makeDefaultQueryInfo() {
    return {
      seen: false,
      observable: null
    };
  }

  var RenderPromises = function () {
    function RenderPromises() {
      this.queryPromises = new Map();
      this.queryInfoTrie = new Map();
    }

    RenderPromises.prototype.registerSSRObservable = function (observable, props) {
      this.lookupQueryInfo(props).observable = observable;
    };

    RenderPromises.prototype.getSSRObservable = function (props) {
      return this.lookupQueryInfo(props).observable;
    };

    RenderPromises.prototype.addQueryPromise = function (queryInstance, finish) {
      var info = this.lookupQueryInfo(queryInstance.getOptions());

      if (!info.seen) {
        this.queryPromises.set(queryInstance.getOptions(), new Promise(function (resolve) {
          resolve(queryInstance.fetchData());
        }));
        return null;
      }

      return finish();
    };

    RenderPromises.prototype.hasPromises = function () {
      return this.queryPromises.size > 0;
    };

    RenderPromises.prototype.consumeAndAwaitPromises = function () {
      var _this = this;

      var promises = [];
      this.queryPromises.forEach(function (promise, queryInstance) {
        _this.lookupQueryInfo(queryInstance).seen = true;
        promises.push(promise);
      });
      this.queryPromises.clear();
      return Promise.all(promises);
    };

    RenderPromises.prototype.lookupQueryInfo = function (props) {
      var queryInfoTrie = this.queryInfoTrie;
      var query = props.query,
          variables = props.variables;
      var varMap = queryInfoTrie.get(query) || new Map();
      if (!queryInfoTrie.has(query)) queryInfoTrie.set(query, varMap);
      var variablesString = JSON.stringify(variables);
      var info = varMap.get(variablesString) || makeDefaultQueryInfo();
      if (!varMap.has(variablesString)) varMap.set(variablesString, info);
      return info;
    };

    return RenderPromises;
  }(); 


  _exports.RenderPromises = RenderPromises;
});
