"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const react_styles_1 = require("@patternfly/react-styles");
const table_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Table/table"));
const headerUtils_1 = require("./utils/headerUtils");
exports.BodyWrapper = (_a) => {
    var { mappedRows, tbodyRef, 
    /* eslint-disable @typescript-eslint/no-unused-vars */
    rows = [], onCollapse, headerRows } = _a, 
    /* eslint-enable @typescript-eslint/no-unused-vars */
    props = tslib_1.__rest(_a, ["mappedRows", "tbodyRef", "rows", "onCollapse", "headerRows"]);
    if (mappedRows && mappedRows.some(row => row.hasOwnProperty('parent'))) {
        return (React.createElement(React.Fragment, null, headerUtils_1.mapOpenedRows(mappedRows, props.children).map((oneRow, key) => (React.createElement("tbody", Object.assign({}, props, { className: react_styles_1.css(oneRow.isOpen && table_1.default.modifiers.expanded), key: `tbody-${key}`, ref: tbodyRef }), oneRow.rows)))));
    }
    return React.createElement("tbody", Object.assign({}, props, { ref: tbodyRef }));
};
exports.BodyWrapper.displayName = 'BodyWrapper';
//# sourceMappingURL=BodyWrapper.js.map