import { __rest } from "tslib";
import React from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/TreeView/tree-view';
import { TreeViewSearch } from './TreeViewSearch';
import { Divider } from '../Divider';
export const TreeViewList = (_a) => {
    var { isNested = false, onSearch, searchProps, children } = _a, props = __rest(_a, ["isNested", "onSearch", "searchProps", "children"]);
    const list = React.createElement("ul", { role: isNested ? 'group' : 'tree' }, children);
    return isNested ? (list) : (React.createElement("div", Object.assign({ className: css(styles.treeView) }, props),
        onSearch && (React.createElement(React.Fragment, null,
            React.createElement(TreeViewSearch, Object.assign({ onChange: onSearch }, searchProps)),
            React.createElement(Divider, null))),
        list));
};
TreeViewList.displayName = 'TreeViewList';
//# sourceMappingURL=TreeViewList.js.map