---
id: Drawer
section: components
wrapperTag: div
---## Demos

### Collapsed

```html isFullscreen
<div class="pf-c-page" id="drawer-default">
  <a class="pf-c-skip-to-content pf-c-button pf-m-primary" href="#main-content-drawer-default">Skip to content</a>
  <header class="pf-c-page__header">
    <div class="pf-c-page__header-brand">
      <div class="pf-c-page__header-brand-toggle">
        <button class="pf-c-button pf-m-plain" type="button" id="drawer-default-nav-toggle" aria-label="Global navigation" aria-expanded="true" aria-controls="drawer-default-primary-nav">
          <i class="fas fa-bars" aria-hidden="true"></i>
        </button>
      </div>
      <a href="#" class="pf-c-page__header-brand-link">
        <img class="pf-c-brand" src="/assets/images/PF-Masthead-Logo.svg" alt="PatternFly logo" />
      </a>
    </div>
    <div class="pf-c-page__header-tools">
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="false">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Settings">
            <i class="fas fa-cog" aria-hidden="true"></i>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Help">
            <i class="pf-icon pf-icon-help" aria-hidden="true"></i>
          </button>
        </div>
      </div>
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-hidden-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="false">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden-on-lg">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-default-dropdown-kebab-right-aligned-1-button" aria-expanded="false" aria-label="Actions">
              <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
            </button>
            <ul class="pf-c-dropdown__menu pf-m-align-right" aria-labelledby="drawer-default-dropdown-kebab-right-aligned-1-button" hidden>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button">Action</button>
              </li>
              <li>
                <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
              </li>
            </ul>
          </div>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-md">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-default-dropdown-button" aria-expanded="false">
              <span class="pf-c-dropdown__toggle-text">John Smith</span>
              <span class="pf-c-dropdown__toggle-icon">
                <i class="fas fa-caret-down" aria-hidden="true"></i>
              </span>
            </button>
            <div class="pf-c-dropdown__menu" hidden>[Panel contents here]</div>
          </div>
        </div>
      </div>
      <img class="pf-c-avatar" src="/assets/images/img_avatar.svg" alt="Avatar image" />
    </div>
  </header>
  <div class="pf-c-page__sidebar">
    <div class="pf-c-page__sidebar-body">
      <nav class="pf-c-nav" id="drawer-default-primary-nav" aria-label="Global">
        <ul class="pf-c-nav__list">
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link pf-m-current" aria-current="page">System panel</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Policy</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Authentication</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Network services</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Server</a>
          </li>
        </ul>
      </nav>
    </div>
  </div>
  <div class="pf-c-page__drawer">
    <div class="pf-c-drawer">
      <div class="pf-c-drawer__main">
        <div class="pf-c-drawer__content">
          <div class="pf-c-drawer__body">
            <main class="pf-c-page__main" tabindex="-1">
              <section class="pf-c-page__main-breadcrumb pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <nav class="pf-c-breadcrumb" aria-label="breadcrumb">
                    <ol class="pf-c-breadcrumb__list">
                      <li class="pf-c-breadcrumb__item">
                        <a href="#" class="pf-c-breadcrumb__link">Section home</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link pf-m-current" aria-current="page">Section landing</a>
                      </li>
                    </ol>
                  </nav>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width pf-m-light ">
                <div class="pf-c-page__main-body">
                  <div class="pf-c-content">
                    <h1>Main title</h1>
                    <p>This is a demo of the Page component.</p>
                  </div>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <div class="pf-l-gallery pf-m-gutter">
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                  </div>
                </div>
              </section>
            </main>
          </div>
        </div>
        <div class="pf-c-drawer__panel pf-m-width-33" hidden>
          <div class="pf-c-drawer__body">
            <p>drawer panel</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
```

### Expanded

```html isFullscreen
<div class="pf-c-page" id="drawer-default-expanded">
  <a class="pf-c-skip-to-content pf-c-button pf-m-primary" href="#main-content-drawer-default-expanded">Skip to content</a>
  <header class="pf-c-page__header">
    <div class="pf-c-page__header-brand">
      <div class="pf-c-page__header-brand-toggle">
        <button class="pf-c-button pf-m-plain" type="button" id="drawer-default-expanded-nav-toggle" aria-label="Global navigation" aria-expanded="true" aria-controls="drawer-default-expanded-primary-nav">
          <i class="fas fa-bars" aria-hidden="true"></i>
        </button>
      </div>
      <a href="#" class="pf-c-page__header-brand-link">
        <img class="pf-c-brand" src="/assets/images/PF-Masthead-Logo.svg" alt="PatternFly logo" />
      </a>
    </div>
    <div class="pf-c-page__header-tools">
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-selected pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="true">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Settings">
            <i class="fas fa-cog" aria-hidden="true"></i>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Help">
            <i class="pf-icon pf-icon-help" aria-hidden="true"></i>
          </button>
        </div>
      </div>
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-selected pf-m-hidden-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="true">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden-on-lg">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-default-expanded-dropdown-kebab-right-aligned-1-button" aria-expanded="false" aria-label="Actions">
              <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
            </button>
            <ul class="pf-c-dropdown__menu pf-m-align-right" aria-labelledby="drawer-default-expanded-dropdown-kebab-right-aligned-1-button" hidden>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button">Action</button>
              </li>
              <li>
                <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
              </li>
            </ul>
          </div>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-md">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-default-expanded-dropdown-button" aria-expanded="false">
              <span class="pf-c-dropdown__toggle-text">John Smith</span>
              <span class="pf-c-dropdown__toggle-icon">
                <i class="fas fa-caret-down" aria-hidden="true"></i>
              </span>
            </button>
            <div class="pf-c-dropdown__menu" hidden>[Panel contents here]</div>
          </div>
        </div>
      </div>
      <img class="pf-c-avatar" src="/assets/images/img_avatar.svg" alt="Avatar image" />
    </div>
  </header>
  <div class="pf-c-page__sidebar">
    <div class="pf-c-page__sidebar-body">
      <nav class="pf-c-nav" id="drawer-default-expanded-primary-nav" aria-label="Global">
        <ul class="pf-c-nav__list">
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link pf-m-current" aria-current="page">System panel</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Policy</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Authentication</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Network services</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Server</a>
          </li>
        </ul>
      </nav>
    </div>
  </div>
  <div class="pf-c-page__drawer">
    <div class="pf-c-drawer pf-m-expanded">
      <div class="pf-c-drawer__main">
        <div class="pf-c-drawer__content">
          <div class="pf-c-drawer__body">
            <main class="pf-c-page__main" tabindex="-1">
              <section class="pf-c-page__main-breadcrumb pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <nav class="pf-c-breadcrumb" aria-label="breadcrumb">
                    <ol class="pf-c-breadcrumb__list">
                      <li class="pf-c-breadcrumb__item">
                        <a href="#" class="pf-c-breadcrumb__link">Section home</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link pf-m-current" aria-current="page">Section landing</a>
                      </li>
                    </ol>
                  </nav>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width pf-m-light ">
                <div class="pf-c-page__main-body">
                  <div class="pf-c-content">
                    <h1>Main title</h1>
                    <p>This is a demo of the Page component.</p>
                  </div>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <div class="pf-l-gallery pf-m-gutter">
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                  </div>
                </div>
              </section>
            </main>
          </div>
        </div>
        <div class="pf-c-drawer__panel pf-m-width-33">
          <div class="pf-c-drawer__body">
            <p>drawer panel</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
```

### Expanded bottom

```html isFullscreen
<div class="pf-c-page" id="drawer-default-expanded">
  <a class="pf-c-skip-to-content pf-c-button pf-m-primary" href="#main-content-drawer-default-expanded">Skip to content</a>
  <header class="pf-c-page__header">
    <div class="pf-c-page__header-brand">
      <div class="pf-c-page__header-brand-toggle">
        <button class="pf-c-button pf-m-plain" type="button" id="drawer-default-expanded-nav-toggle" aria-label="Global navigation" aria-expanded="true" aria-controls="drawer-default-expanded-primary-nav">
          <i class="fas fa-bars" aria-hidden="true"></i>
        </button>
      </div>
      <a href="#" class="pf-c-page__header-brand-link">
        <img class="pf-c-brand" src="/assets/images/PF-Masthead-Logo.svg" alt="PatternFly logo" />
      </a>
    </div>
    <div class="pf-c-page__header-tools">
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-selected pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="true">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Settings">
            <i class="fas fa-cog" aria-hidden="true"></i>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Help">
            <i class="pf-icon pf-icon-help" aria-hidden="true"></i>
          </button>
        </div>
      </div>
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-selected pf-m-hidden-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="true">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden-on-lg">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-default-expanded-dropdown-kebab-right-aligned-1-button" aria-expanded="false" aria-label="Actions">
              <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
            </button>
            <ul class="pf-c-dropdown__menu pf-m-align-right" aria-labelledby="drawer-default-expanded-dropdown-kebab-right-aligned-1-button" hidden>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button">Action</button>
              </li>
              <li>
                <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
              </li>
            </ul>
          </div>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-md">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-default-expanded-dropdown-button" aria-expanded="false">
              <span class="pf-c-dropdown__toggle-text">John Smith</span>
              <span class="pf-c-dropdown__toggle-icon">
                <i class="fas fa-caret-down" aria-hidden="true"></i>
              </span>
            </button>
            <div class="pf-c-dropdown__menu" hidden>[Panel contents here]</div>
          </div>
        </div>
      </div>
      <img class="pf-c-avatar" src="/assets/images/img_avatar.svg" alt="Avatar image" />
    </div>
  </header>
  <div class="pf-c-page__sidebar">
    <div class="pf-c-page__sidebar-body">
      <nav class="pf-c-nav" id="drawer-default-expanded-primary-nav" aria-label="Global">
        <ul class="pf-c-nav__list">
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link pf-m-current" aria-current="page">System panel</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Policy</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Authentication</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Network services</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Server</a>
          </li>
        </ul>
      </nav>
    </div>
  </div>
  <div class="pf-c-page__drawer">
    <div class="pf-c-drawer pf-m-panel-bottom pf-m-expanded">
      <div class="pf-c-drawer__main">
        <div class="pf-c-drawer__content">
          <div class="pf-c-drawer__body">
            <main class="pf-c-page__main" tabindex="-1">
              <section class="pf-c-page__main-breadcrumb pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <nav class="pf-c-breadcrumb" aria-label="breadcrumb">
                    <ol class="pf-c-breadcrumb__list">
                      <li class="pf-c-breadcrumb__item">
                        <a href="#" class="pf-c-breadcrumb__link">Section home</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link pf-m-current" aria-current="page">Section landing</a>
                      </li>
                    </ol>
                  </nav>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width pf-m-light ">
                <div class="pf-c-page__main-body">
                  <div class="pf-c-content">
                    <h1>Main title</h1>
                    <p>This is a demo of the Page component.</p>
                  </div>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <div class="pf-l-gallery pf-m-gutter">
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                  </div>
                </div>
              </section>
            </main>
          </div>
        </div>
        <div class="pf-c-drawer__panel pf-m-width-33">
          <div class="pf-c-drawer__body">
            <p>drawer panel</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
```

### Unread

```html isFullscreen
<div class="pf-c-page" id="drawer-unread">
  <a class="pf-c-skip-to-content pf-c-button pf-m-primary" href="#main-content-drawer-unread">Skip to content</a>
  <header class="pf-c-page__header">
    <div class="pf-c-page__header-brand">
      <div class="pf-c-page__header-brand-toggle">
        <button class="pf-c-button pf-m-plain" type="button" id="drawer-unread-nav-toggle" aria-label="Global navigation" aria-expanded="true" aria-controls="drawer-unread-primary-nav">
          <i class="fas fa-bars" aria-hidden="true"></i>
        </button>
      </div>
      <a href="#" class="pf-c-page__header-brand-link">
        <img class="pf-c-brand" src="/assets/images/PF-Masthead-Logo.svg" alt="PatternFly logo" />
      </a>
    </div>
    <div class="pf-c-page__header-tools">
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="false">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Settings">
            <i class="fas fa-cog" aria-hidden="true"></i>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Help">
            <i class="pf-icon pf-icon-help" aria-hidden="true"></i>
          </button>
        </div>
      </div>
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-hidden-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="false">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden-on-lg">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-unread-dropdown-kebab-right-aligned-1-button" aria-expanded="false" aria-label="Actions">
              <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
            </button>
            <ul class="pf-c-dropdown__menu pf-m-align-right" aria-labelledby="drawer-unread-dropdown-kebab-right-aligned-1-button" hidden>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button">Action</button>
              </li>
              <li>
                <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
              </li>
            </ul>
          </div>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-md">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-unread-dropdown-button" aria-expanded="false">
              <span class="pf-c-dropdown__toggle-text">John Smith</span>
              <span class="pf-c-dropdown__toggle-icon">
                <i class="fas fa-caret-down" aria-hidden="true"></i>
              </span>
            </button>
            <div class="pf-c-dropdown__menu" hidden>[Panel contents here]</div>
          </div>
        </div>
      </div>
      <img class="pf-c-avatar" src="/assets/images/img_avatar.svg" alt="Avatar image" />
    </div>
  </header>
  <div class="pf-c-page__sidebar">
    <div class="pf-c-page__sidebar-body">
      <nav class="pf-c-nav" id="drawer-unread-primary-nav" aria-label="Global">
        <ul class="pf-c-nav__list">
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link pf-m-current" aria-current="page">System panel</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Policy</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Authentication</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Network services</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Server</a>
          </li>
        </ul>
      </nav>
    </div>
  </div>
  <div class="pf-c-page__drawer">
    <div class="pf-c-drawer">
      <div class="pf-c-drawer__main">
        <div class="pf-c-drawer__content">
          <div class="pf-c-drawer__body">
            <main class="pf-c-page__main" tabindex="-1">
              <section class="pf-c-page__main-breadcrumb pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <nav class="pf-c-breadcrumb" aria-label="breadcrumb">
                    <ol class="pf-c-breadcrumb__list">
                      <li class="pf-c-breadcrumb__item">
                        <a href="#" class="pf-c-breadcrumb__link">Section home</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link pf-m-current" aria-current="page">Section landing</a>
                      </li>
                    </ol>
                  </nav>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width pf-m-light ">
                <div class="pf-c-page__main-body">
                  <div class="pf-c-content">
                    <h1>Main title</h1>
                    <p>This is a demo of the Page component.</p>
                  </div>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <div class="pf-l-gallery pf-m-gutter">
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                  </div>
                </div>
              </section>
            </main>
          </div>
        </div>
        <div class="pf-c-drawer__panel pf-m-width-33" hidden>
          <div class="pf-c-drawer__body">
            <p>drawer panel</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
```

### Unread expanded

```html isFullscreen
<div class="pf-c-page" id="drawer-unread-expanded">
  <a class="pf-c-skip-to-content pf-c-button pf-m-primary" href="#main-content-drawer-unread-expanded">Skip to content</a>
  <header class="pf-c-page__header">
    <div class="pf-c-page__header-brand">
      <div class="pf-c-page__header-brand-toggle">
        <button class="pf-c-button pf-m-plain" type="button" id="drawer-unread-expanded-nav-toggle" aria-label="Global navigation" aria-expanded="true" aria-controls="drawer-unread-expanded-primary-nav">
          <i class="fas fa-bars" aria-hidden="true"></i>
        </button>
      </div>
      <a href="#" class="pf-c-page__header-brand-link">
        <img class="pf-c-brand" src="/assets/images/PF-Masthead-Logo.svg" alt="PatternFly logo" />
      </a>
    </div>
    <div class="pf-c-page__header-tools">
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-selected pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="true">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Settings">
            <i class="fas fa-cog" aria-hidden="true"></i>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Help">
            <i class="pf-icon pf-icon-help" aria-hidden="true"></i>
          </button>
        </div>
      </div>
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-selected pf-m-hidden-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="true">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden-on-lg">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-unread-expanded-dropdown-kebab-right-aligned-1-button" aria-expanded="false" aria-label="Actions">
              <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
            </button>
            <ul class="pf-c-dropdown__menu pf-m-align-right" aria-labelledby="drawer-unread-expanded-dropdown-kebab-right-aligned-1-button" hidden>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button">Action</button>
              </li>
              <li>
                <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
              </li>
            </ul>
          </div>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-md">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-unread-expanded-dropdown-button" aria-expanded="false">
              <span class="pf-c-dropdown__toggle-text">John Smith</span>
              <span class="pf-c-dropdown__toggle-icon">
                <i class="fas fa-caret-down" aria-hidden="true"></i>
              </span>
            </button>
            <div class="pf-c-dropdown__menu" hidden>[Panel contents here]</div>
          </div>
        </div>
      </div>
      <img class="pf-c-avatar" src="/assets/images/img_avatar.svg" alt="Avatar image" />
    </div>
  </header>
  <div class="pf-c-page__sidebar">
    <div class="pf-c-page__sidebar-body">
      <nav class="pf-c-nav" id="drawer-unread-expanded-primary-nav" aria-label="Global">
        <ul class="pf-c-nav__list">
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link pf-m-current" aria-current="page">System panel</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Policy</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Authentication</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Network services</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Server</a>
          </li>
        </ul>
      </nav>
    </div>
  </div>
  <div class="pf-c-page__drawer">
    <div class="pf-c-drawer pf-m-expanded">
      <div class="pf-c-drawer__main">
        <div class="pf-c-drawer__content">
          <div class="pf-c-drawer__body">
            <main class="pf-c-page__main" tabindex="-1">
              <section class="pf-c-page__main-breadcrumb pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <nav class="pf-c-breadcrumb" aria-label="breadcrumb">
                    <ol class="pf-c-breadcrumb__list">
                      <li class="pf-c-breadcrumb__item">
                        <a href="#" class="pf-c-breadcrumb__link">Section home</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link pf-m-current" aria-current="page">Section landing</a>
                      </li>
                    </ol>
                  </nav>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width pf-m-light ">
                <div class="pf-c-page__main-body">
                  <div class="pf-c-content">
                    <h1>Main title</h1>
                    <p>This is a demo of the Page component.</p>
                  </div>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <div class="pf-l-gallery pf-m-gutter">
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                  </div>
                </div>
              </section>
            </main>
          </div>
        </div>
        <div class="pf-c-drawer__panel pf-m-width-33">
          <div class="pf-c-drawer__body">
            <p>drawer panel</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
```

### Attention

```html isFullscreen
<div class="pf-c-page" id="drawer-attention">
  <a class="pf-c-skip-to-content pf-c-button pf-m-primary" href="#main-content-drawer-attention">Skip to content</a>
  <header class="pf-c-page__header">
    <div class="pf-c-page__header-brand">
      <div class="pf-c-page__header-brand-toggle">
        <button class="pf-c-button pf-m-plain" type="button" id="drawer-attention-nav-toggle" aria-label="Global navigation" aria-expanded="true" aria-controls="drawer-attention-primary-nav">
          <i class="fas fa-bars" aria-hidden="true"></i>
        </button>
      </div>
      <a href="#" class="pf-c-page__header-brand-link">
        <img class="pf-c-brand" src="/assets/images/PF-Masthead-Logo.svg" alt="PatternFly logo" />
      </a>
    </div>
    <div class="pf-c-page__header-tools">
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="false">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-attention-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Settings">
            <i class="fas fa-cog" aria-hidden="true"></i>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Help">
            <i class="pf-icon pf-icon-help" aria-hidden="true"></i>
          </button>
        </div>
      </div>
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-hidden-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="false">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-attention-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden-on-lg">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-attention-dropdown-kebab-right-aligned-1-button" aria-expanded="false" aria-label="Actions">
              <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
            </button>
            <ul class="pf-c-dropdown__menu pf-m-align-right" aria-labelledby="drawer-attention-dropdown-kebab-right-aligned-1-button" hidden>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button">Action</button>
              </li>
              <li>
                <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
              </li>
            </ul>
          </div>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-md">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-attention-dropdown-button" aria-expanded="false">
              <span class="pf-c-dropdown__toggle-text">John Smith</span>
              <span class="pf-c-dropdown__toggle-icon">
                <i class="fas fa-caret-down" aria-hidden="true"></i>
              </span>
            </button>
            <div class="pf-c-dropdown__menu" hidden>[Panel contents here]</div>
          </div>
        </div>
      </div>
      <img class="pf-c-avatar" src="/assets/images/img_avatar.svg" alt="Avatar image" />
    </div>
  </header>
  <div class="pf-c-page__sidebar">
    <div class="pf-c-page__sidebar-body">
      <nav class="pf-c-nav" id="drawer-attention-primary-nav" aria-label="Global">
        <ul class="pf-c-nav__list">
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link pf-m-current" aria-current="page">System panel</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Policy</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Authentication</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Network services</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Server</a>
          </li>
        </ul>
      </nav>
    </div>
  </div>
  <div class="pf-c-page__drawer">
    <div class="pf-c-drawer">
      <div class="pf-c-drawer__main">
        <div class="pf-c-drawer__content">
          <div class="pf-c-drawer__body">
            <main class="pf-c-page__main" tabindex="-1">
              <section class="pf-c-page__main-breadcrumb pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <nav class="pf-c-breadcrumb" aria-label="breadcrumb">
                    <ol class="pf-c-breadcrumb__list">
                      <li class="pf-c-breadcrumb__item">
                        <a href="#" class="pf-c-breadcrumb__link">Section home</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link pf-m-current" aria-current="page">Section landing</a>
                      </li>
                    </ol>
                  </nav>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width pf-m-light ">
                <div class="pf-c-page__main-body">
                  <div class="pf-c-content">
                    <h1>Main title</h1>
                    <p>This is a demo of the Page component.</p>
                  </div>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <div class="pf-l-gallery pf-m-gutter">
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                  </div>
                </div>
              </section>
            </main>
          </div>
        </div>
        <div class="pf-c-drawer__panel pf-m-width-33" hidden>
          <div class="pf-c-drawer__body">
            <p>drawer panel</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
```

### Attention expanded

```html isFullscreen
<div class="pf-c-page" id="drawer-attention-expanded">
  <a class="pf-c-skip-to-content pf-c-button pf-m-primary" href="#main-content-drawer-attention-expanded">Skip to content</a>
  <header class="pf-c-page__header">
    <div class="pf-c-page__header-brand">
      <div class="pf-c-page__header-brand-toggle">
        <button class="pf-c-button pf-m-plain" type="button" id="drawer-attention-expanded-nav-toggle" aria-label="Global navigation" aria-expanded="true" aria-controls="drawer-attention-expanded-primary-nav">
          <i class="fas fa-bars" aria-hidden="true"></i>
        </button>
      </div>
      <a href="#" class="pf-c-page__header-brand-link">
        <img class="pf-c-brand" src="/assets/images/PF-Masthead-Logo.svg" alt="PatternFly logo" />
      </a>
    </div>
    <div class="pf-c-page__header-tools">
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-selected pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="true">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-attention-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Settings">
            <i class="fas fa-cog" aria-hidden="true"></i>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Help">
            <i class="pf-icon pf-icon-help" aria-hidden="true"></i>
          </button>
        </div>
      </div>
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-selected pf-m-hidden-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Unread notifications" aria-expanded="true">
            <span class="pf-c-notification-badge pf-m-read">
              <i class="pf-icon-attention-bell" aria-hidden="true"></i>
            </span>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden-on-lg">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-attention-expanded-dropdown-kebab-right-aligned-1-button" aria-expanded="false" aria-label="Actions">
              <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
            </button>
            <ul class="pf-c-dropdown__menu pf-m-align-right" aria-labelledby="drawer-attention-expanded-dropdown-kebab-right-aligned-1-button" hidden>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button">Action</button>
              </li>
              <li>
                <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
              </li>
            </ul>
          </div>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-md">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="drawer-attention-expanded-dropdown-button" aria-expanded="false">
              <span class="pf-c-dropdown__toggle-text">John Smith</span>
              <span class="pf-c-dropdown__toggle-icon">
                <i class="fas fa-caret-down" aria-hidden="true"></i>
              </span>
            </button>
            <div class="pf-c-dropdown__menu" hidden>[Panel contents here]</div>
          </div>
        </div>
      </div>
      <img class="pf-c-avatar" src="/assets/images/img_avatar.svg" alt="Avatar image" />
    </div>
  </header>
  <div class="pf-c-page__sidebar">
    <div class="pf-c-page__sidebar-body">
      <nav class="pf-c-nav" id="drawer-attention-expanded-primary-nav" aria-label="Global">
        <ul class="pf-c-nav__list">
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link pf-m-current" aria-current="page">System panel</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Policy</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Authentication</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Network services</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Server</a>
          </li>
        </ul>
      </nav>
    </div>
  </div>
  <div class="pf-c-page__drawer">
    <div class="pf-c-drawer pf-m-expanded">
      <div class="pf-c-drawer__main">
        <div class="pf-c-drawer__content">
          <div class="pf-c-drawer__body">
            <main class="pf-c-page__main" tabindex="-1">
              <section class="pf-c-page__main-breadcrumb pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <nav class="pf-c-breadcrumb" aria-label="breadcrumb">
                    <ol class="pf-c-breadcrumb__list">
                      <li class="pf-c-breadcrumb__item">
                        <a href="#" class="pf-c-breadcrumb__link">Section home</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link">Section title</a>
                      </li>
                      <li class="pf-c-breadcrumb__item">
                        <span class="pf-c-breadcrumb__item-divider">
                          <i class="fas fa-angle-right" aria-hidden="true"></i>
                        </span>
                        <a href="#" class="pf-c-breadcrumb__link pf-m-current" aria-current="page">Section landing</a>
                      </li>
                    </ol>
                  </nav>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width pf-m-light ">
                <div class="pf-c-page__main-body">
                  <div class="pf-c-content">
                    <h1>Main title</h1>
                    <p>This is a demo of the Page component.</p>
                  </div>
                </div>
              </section>
              <section class="pf-c-page__main-section pf-m-limit-width">
                <div class="pf-c-page__main-body">
                  <div class="pf-l-gallery pf-m-gutter">
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                    <div class="pf-l-gallery__item">
                      <div class="pf-c-card">
                        <div class="pf-c-card__body">This is a card</div>
                      </div>
                    </div>
                  </div>
                </div>
              </section>
            </main>
          </div>
        </div>
        <div class="pf-c-drawer__panel pf-m-width-33">
          <div class="pf-c-drawer__body">
            <p>drawer panel</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
```

## Documentation

This demo implements the drawer in context of the page component.
