'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _lodash = require('lodash.isequal');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Selection = function (_React$Component) {
  _inherits(Selection, _React$Component);

  function Selection(props) {
    _classCallCheck(this, Selection);

    var _this = _possibleConstructorReturn(this, (Selection.__proto__ || Object.getPrototypeOf(Selection)).call(this, props));

    _this.internalSetState = function (stateToSet, callback) {
      return _this.setState(stateToSet, function () {
        if (callback) {
          callback();
        }
        if (_this.props.onChange) {
          _this.props.onChange(_this.state);
        }
      });
    };

    _this.handleClearSelection = function () {
      _this.internalSetState({
        selectedItems: []
      });
    };

    _this.handleSelectItem = function (item) {
      var items = Array.isArray(item) ? item : [item];
      _this.internalSetState(function (prevState) {
        return {
          selectedItems: [].concat(_toConsumableArray(prevState.selectedItems), _toConsumableArray(items))
        };
      });
    };

    _this.handleRemoveItem = function (item) {
      var items = Array.isArray(item) ? item : [item];
      _this.internalSetState(function (prevState) {
        var newState = {
          selectedItems: prevState.selectedItems.filter(function (itemOnState) {
            return items.indexOf(itemOnState) === -1;
          })
        };
        return newState;
      });
    };

    _this.handleOnItemChange = function (item) {
      var selectedItems = _this.state.selectedItems;


      var itemsToProcess = Array.isArray(item) ? item : [item];
      var result = itemsToProcess.reduce(function (acc, theItem) {
        var selectedIndex = void 0;
        selectedItems.some(function (selectedItem, index) {
          if ((0, _lodash2.default)(selectedItem, theItem)) {
            selectedIndex = index;
            return true;
          }
          return false;
        });
        if (selectedIndex === undefined) {
          acc.itemsToSelect.push(theItem);
        } else {
          acc.itemsToRemove.push(selectedItems[selectedIndex]);
        }
        return acc;
      }, {
        itemsToSelect: [],
        itemsToRemove: []
      });

      if (result.itemsToSelect.length > 0) {
        _this.handleSelectItem(result.itemsToSelect);
      }
      if (result.itemsToRemove.length > 0) {
        _this.handleRemoveItem(result.itemsToRemove);
      }
    };

    _this.state = {
      selectedItems: props.initialSelectedItems
    };
    return _this;
  }

  _createClass(Selection, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          render = _props.render;
      var selectedItems = this.state.selectedItems;

      var renderProps = {
        selectedItems: selectedItems,
        onItemChange: this.handleOnItemChange,
        clearSelection: this.handleClearSelection
      };

      if (render !== undefined) {
        return render(renderProps);
      }

      if (children !== undefined) {
        return children(renderProps);
      }

      return null;
    }
  }]);

  return Selection;
}(_react2.default.Component);

Selection.propTypes = {
  initialSelectedItems: _propTypes2.default.array.isRequired
};
Selection.defaultProps = {
  initialSelectedItems: []
};
exports.default = Selection;