import { __rest } from "tslib";
import * as React from 'react';
import { useState } from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/Alert/alert';
import accessibleStyles from '@patternfly/react-styles/css/utilities/Accessibility/accessibility';
import { AlertIcon } from './AlertIcon';
import { capitalize, useOUIAProps } from '../../helpers';
import { AlertContext } from './AlertContext';
import maxLines from "@patternfly/react-tokens/dist/esm/c_alert__title_max_lines";
import { Tooltip } from '../Tooltip';
export var AlertVariant;
(function (AlertVariant) {
    AlertVariant["success"] = "success";
    AlertVariant["danger"] = "danger";
    AlertVariant["warning"] = "warning";
    AlertVariant["info"] = "info";
    AlertVariant["default"] = "default";
})(AlertVariant || (AlertVariant = {}));
export const Alert = (_a) => {
    var { variant = AlertVariant.default, isInline = false, isLiveRegion = false, variantLabel = `${capitalize(variant)} alert:`, 'aria-label': ariaLabel = `${capitalize(variant)} Alert`, actionClose, actionLinks, title, children = '', className = '', ouiaId, ouiaSafe = true, timeout = false, onTimeout, truncateTitle = 0, tooltipPosition } = _a, props = __rest(_a, ["variant", "isInline", "isLiveRegion", "variantLabel", 'aria-label', "actionClose", "actionLinks", "title", "children", "className", "ouiaId", "ouiaSafe", "timeout", "onTimeout", "truncateTitle", "tooltipPosition"]);
    const ouiaProps = useOUIAProps(Alert.displayName, ouiaId, ouiaSafe, variant);
    const getHeadingContent = (React.createElement(React.Fragment, null,
        React.createElement("span", { className: css(accessibleStyles.screenReader) }, variantLabel),
        title));
    const [disableAlert, setDisableAlert] = useState(false);
    const [isTooltipVisible, setIsTooltipVisible] = useState(false);
    const titleRef = React.useRef(null);
    React.useEffect(() => {
        if (!titleRef.current || !truncateTitle) {
            return;
        }
        titleRef.current.style.setProperty(maxLines.name, truncateTitle.toString());
        const showTooltip = titleRef.current && titleRef.current.offsetHeight < titleRef.current.scrollHeight;
        if (isTooltipVisible !== showTooltip) {
            setIsTooltipVisible(showTooltip);
        }
    }, [titleRef, truncateTitle, isTooltipVisible]);
    const customClassName = css(styles.alert, isInline && styles.modifiers.inline, variant !== AlertVariant.default && styles.modifiers[variant], className);
    const Title = (React.createElement("h4", Object.assign({}, (isTooltipVisible && { tabIndex: 0 }), { ref: titleRef, className: css(styles.alertTitle, truncateTitle && styles.modifiers.truncate) }), getHeadingContent));
    if (disableAlert === false && timeout && timeout !== 0) {
        setTimeout(() => {
            setDisableAlert(true);
            if (onTimeout) {
                onTimeout();
            }
        }, timeout === true ? 8000 : timeout);
    }
    if (disableAlert === false) {
        return (React.createElement("div", Object.assign({}, props, { className: customClassName, "aria-label": ariaLabel }, ouiaProps, (isLiveRegion && {
            'aria-live': 'polite',
            'aria-atomic': 'false'
        })),
            React.createElement(AlertIcon, { variant: variant }),
            isTooltipVisible ? (React.createElement(Tooltip, { content: getHeadingContent, position: tooltipPosition }, Title)) : (Title),
            actionClose && (React.createElement(AlertContext.Provider, { value: { title, variantLabel } },
                React.createElement("div", { className: css(styles.alertAction) }, actionClose))),
            children && React.createElement("div", { className: css(styles.alertDescription) }, children),
            actionLinks && React.createElement("div", { className: css(styles.alertActionGroup) }, actionLinks)));
    }
    else {
        return null;
    }
};
Alert.displayName = 'Alert';
//# sourceMappingURL=Alert.js.map