import * as React from 'react';
import { PickOptional } from '../../helpers/typeUtils';
export declare enum DataListWrapModifier {
    nowrap = "nowrap",
    truncate = "truncate",
    breakWord = "breakWord"
}
export interface DataListProps extends Omit<React.HTMLProps<HTMLUListElement>, 'onDragStart' | 'ref'> {
    /** Content rendered inside the DataList list */
    children?: React.ReactNode;
    /** Additional classes added to the DataList list */
    className?: string;
    /** Adds accessible text to the DataList list */
    'aria-label': string;
    /** Optional callback to make DataList selectable, fired when DataListItem selected */
    onSelectDataListItem?: (id: string) => void;
    /** Optional callback to make DataList draggable, fired when dragging ends */
    onDragFinish?: (newItemOrder: string[]) => void;
    /** Optional informational callback for dragging, fired when dragging starts */
    onDragStart?: (id: string) => void;
    /** Optional informational callback for dragging, fired when an item moves */
    onDragMove?: (oldIndex: number, newIndex: number) => void;
    /** Optional informational callback for dragging, fired when dragging is cancelled */
    onDragCancel?: () => void;
    /** Id of DataList item currently selected */
    selectedDataListItemId?: string;
    /** Flag indicating if DataList should have compact styling */
    isCompact?: boolean;
    /** Specifies the grid breakpoints  */
    gridBreakpoint?: 'none' | 'always' | 'sm' | 'md' | 'lg' | 'xl' | '2xl';
    /** Determines which wrapping modifier to apply to the DataList */
    wrapModifier?: DataListWrapModifier | 'nowrap' | 'truncate' | 'breakWord';
    /** Order of items in a draggable DataList */
    itemOrder?: string[];
}
interface DataListState {
    draggedItemId: string;
    draggingToItemIndex: number;
    dragging: boolean;
    tempItemOrder: string[];
}
interface DataListContextProps {
    isSelectable: boolean;
    selectedDataListItemId: string;
    updateSelectedDataListItem: (id: string) => void;
    isDraggable: boolean;
    dragStart: (e: React.DragEvent) => void;
    dragEnd: (e: React.DragEvent) => void;
    dragKeyHandler: (e: React.KeyboardEvent) => void;
}
export declare const DataListContext: React.Context<Partial<DataListContextProps>>;
export declare class DataList extends React.Component<DataListProps, DataListState> {
    static displayName: string;
    static defaultProps: PickOptional<DataListProps>;
    dragFinished: boolean;
    arrayCopy: React.ReactElement[];
    ref: React.RefObject<HTMLUListElement>;
    state: DataListState;
    componentDidUpdate(oldProps: DataListProps): void;
    getIndex: (id: string) => number;
    move: (itemOrder: string[]) => void;
    dragStart0: (el: HTMLElement) => void;
    dragStart: (evt: React.DragEvent) => void;
    onDragCancel: () => void;
    dragLeave: (evt: React.DragEvent) => void;
    dragEnd0: (el: HTMLElement) => void;
    isValidDrop: (evt: React.DragEvent) => boolean;
    dragEnd: (evt: React.DragEvent) => void;
    dragOver0: (id: string) => void;
    dragOver: (evt: React.DragEvent) => string | null;
    handleDragButtonKeys: (evt: React.KeyboardEvent) => void;
    render(): JSX.Element;
}
export {};
//# sourceMappingURL=DataList.d.ts.map