---
id: Menu
section: components
beta: true
cssPrefix: pf-c-menu
---import './Menu.css'

## Examples

### Basic

```html
<div class="pf-c-menu">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Action</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <a class="pf-c-menu__item" href="#">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Link</span>
          </div>
        </a>
      </li>
      <li class="pf-c-menu__list-item pf-m-disabled">
        <button class="pf-c-menu__item" type="button" disabled>
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Disabled action</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item pf-m-disabled">
        <a class="pf-c-menu__item aria-disabled&#x3D;&quot;true&quot; tabindex&#x3D;&quot;-1&quot;" href="#">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Disabled link</span>
          </div>
        </a>
      </li>
    </ul>
  </div>
</div>
```

### With icons

```html
<div class="pf-c-menu">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-icon">
              <i class="fas fa-fw fa-code-branch" aria-hidden="true"></i>
            </span>
            <span class="pf-c-menu__item-text">From Git</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-icon">
              <i class="fas fa-fw fa-layer-group" aria-hidden="true"></i>
            </span>
            <span class="pf-c-menu__item-text">Container image</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-icon">
              <i class="fas fa-fw fa-cube" aria-hidden="true"></i>
            </span>
            <span class="pf-c-menu__item-text">From DockerFile</span>
          </div>
        </button>
      </li>
    </ul>
  </div>
</div>
```

### With expanded toggle

```html
<div class="pf-c-menu">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">From Git</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Container image</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-icon">
              <i class="fas fa-fw fa-cube" aria-hidden="true"></i>
            </span>
            <span class="pf-c-menu__item-text">From DockerFile</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
          <div class="pf-c-menu__item-description">Description</div>
        </button>
      </li>
    </ul>
  </div>
</div>
```

### With flyout

```html
<div class="pf-c-menu pf-m-flyout">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Start rollout</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Pause rollouts</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button" aria-expanded="false">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Add storage</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
        <div class="pf-c-menu" hidden>
          <div class="pf-c-menu__content">
            <ul class="pf-c-menu__list">
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Application grouping</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Count</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Labels</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Annotations</span>
                  </div>
                </button>
              </li>
            </ul>
          </div>
        </div>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button" aria-expanded="true">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Edit</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
          <div class="pf-c-menu__item-description">Description</div>
        </button>
        <div class="pf-c-menu">
          <div class="pf-c-menu__content">
            <ul class="pf-c-menu__list">
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Application grouping</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Count</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Labels</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Annotations</span>
                  </div>
                </button>
              </li>
            </ul>
          </div>
        </div>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Delete deployment config</span>
          </div>
        </button>
      </li>
    </ul>
  </div>
</div>
```

### Drilldown

```html
<div class="pf-c-menu pf-m-drilldown" id="drilldown-default">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Start rollout</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Pause rollout</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Add storage</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button" aria-expanded="false">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Edit</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
        <div class="pf-c-menu" id="drilldown-default-list-1">
          <div class="pf-c-menu__content">
            <ul class="pf-c-menu__list">
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" tabindex="0">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-left"></i>
                    </span>
                    <span class="pf-c-menu__item-text">Edit</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Deployment</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-default-list-1-1">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button" tabindex="0">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Deployment</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Routes</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Nodes</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">URLs</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button" aria-expanded="false">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Advanced settings</span>
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-right"></i>
                            </span>
                          </div>
                        </button>
                        <div class="pf-c-menu" id="drilldown-default-list-1-1-1">
                          <div class="pf-c-menu__content">
                            <ul class="pf-c-menu__list">
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button" tabindex="0">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-toggle-icon">
                                      <i class="fas fa-angle-left"></i>
                                    </span>
                                    <span class="pf-c-menu__item-text">Advanced settings</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-divider" role="separator"></li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Reports</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Policies</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Systems</span>
                                  </div>
                                </button>
                              </li>
                            </ul>
                          </div>
                        </div>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">RBAC</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-default-list-1-2">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">RBAC</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Reports</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Policies</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Systems</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Thing with a longer label</span>
                  </div>
                </button>
              </li>
            </ul>
          </div>
        </div>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button" aria-expanded="false">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Configuration</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
        <div class="pf-c-menu" id="drilldown-default-list-2">
          <div class="pf-c-menu__content">
            <ul class="pf-c-menu__list">
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-left"></i>
                    </span>
                    <span class="pf-c-menu__item-text">Configuration</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Profile</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-default-list-2-1">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Profile</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Avatar</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Name</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Title</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Time zone</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Account settings</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Thing with a longer label</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Edit access settings</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-default-list-2-2">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Edit access settings</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Global access</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Account access</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </div>
      </li>
    </ul>
  </div>
</div>
```

### Drilldown level two

```html
<div class="pf-c-menu pf-m-drilldown pf-m-drilled-in" id="drilldown-level-2" style="--pf-c-menu--m-drilldown--Height: 193px">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Start rollout</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Pause rollout</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Add storage</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item pf-m-current-path">
        <button class="pf-c-menu__item" type="button" aria-expanded="true">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Edit</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
        <div class="pf-c-menu" id="drilldown-level-2-list-1">
          <div class="pf-c-menu__content">
            <ul class="pf-c-menu__list">
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" tabindex="0">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-left"></i>
                    </span>
                    <span class="pf-c-menu__item-text">Edit</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Deployment</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-level-2-list-1-1">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button" tabindex="0">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Deployment</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Routes</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Nodes</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">URLs</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button" aria-expanded="false">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Advanced settings</span>
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-right"></i>
                            </span>
                          </div>
                        </button>
                        <div class="pf-c-menu" id="drilldown-level-2-list-1-1-1">
                          <div class="pf-c-menu__content">
                            <ul class="pf-c-menu__list">
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button" tabindex="0">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-toggle-icon">
                                      <i class="fas fa-angle-left"></i>
                                    </span>
                                    <span class="pf-c-menu__item-text">Advanced settings</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-divider" role="separator"></li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Reports</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Policies</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Systems</span>
                                  </div>
                                </button>
                              </li>
                            </ul>
                          </div>
                        </div>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">RBAC</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-level-2-list-1-2">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">RBAC</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Reports</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Policies</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Systems</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Thing with a longer label</span>
                  </div>
                </button>
              </li>
            </ul>
          </div>
        </div>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button" aria-expanded="false">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Configuration</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
        <div class="pf-c-menu" id="drilldown-level-2-list-2">
          <div class="pf-c-menu__content">
            <ul class="pf-c-menu__list">
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-left"></i>
                    </span>
                    <span class="pf-c-menu__item-text">Configuration</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Profile</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-level-2-list-2-1">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Profile</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Avatar</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Name</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Title</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Time zone</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Account settings</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Thing with a longer label</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Edit access settings</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-level-2-list-2-2">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Edit access settings</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Global access</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Account access</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </div>
      </li>
    </ul>
  </div>
</div>
```

### Drilldown level three

```html
<div class="pf-c-menu pf-m-drilldown pf-m-drilled-in" id="drilldown-level-3" style="--pf-c-menu--m-drilldown--Height: 233px">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Start rollout</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Pause rollout</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Add storage</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item pf-m-current-path">
        <button class="pf-c-menu__item" type="button" aria-expanded="true">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Edit</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
        <div class="pf-c-menu pf-m-drilled-in" id="drilldown-level-3-list-1">
          <div class="pf-c-menu__content">
            <ul class="pf-c-menu__list">
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" tabindex="0">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-left"></i>
                    </span>
                    <span class="pf-c-menu__item-text">Edit</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li class="pf-c-menu__list-item pf-m-current-path">
                <button class="pf-c-menu__item" type="button" aria-expanded="true">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Deployment</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-level-3-list-1-1">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button" tabindex="0">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Deployment</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Routes</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Nodes</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">URLs</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button" aria-expanded="false">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Advanced settings</span>
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-right"></i>
                            </span>
                          </div>
                        </button>
                        <div class="pf-c-menu" id="drilldown-level-3-list-1-1-1">
                          <div class="pf-c-menu__content">
                            <ul class="pf-c-menu__list">
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button" tabindex="0">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-toggle-icon">
                                      <i class="fas fa-angle-left"></i>
                                    </span>
                                    <span class="pf-c-menu__item-text">Advanced settings</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-divider" role="separator"></li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Reports</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Policies</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Systems</span>
                                  </div>
                                </button>
                              </li>
                            </ul>
                          </div>
                        </div>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">RBAC</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-level-3-list-1-2">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">RBAC</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Reports</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Policies</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Systems</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Thing with a longer label</span>
                  </div>
                </button>
              </li>
            </ul>
          </div>
        </div>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button" aria-expanded="false">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Configuration</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
        <div class="pf-c-menu" id="drilldown-level-3-list-2">
          <div class="pf-c-menu__content">
            <ul class="pf-c-menu__list">
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-left"></i>
                    </span>
                    <span class="pf-c-menu__item-text">Configuration</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Profile</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-level-3-list-2-1">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Profile</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Avatar</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Name</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Title</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Time zone</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Account settings</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Thing with a longer label</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Edit access settings</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-level-3-list-2-2">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Edit access settings</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Global access</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Account access</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </div>
      </li>
    </ul>
  </div>
</div>
```

### Drilldown level four

```html
<div class="pf-c-menu pf-m-drilldown pf-m-drilled-in" id="drilldown-level-4" style="--pf-c-menu--m-drilldown--Height: 193px">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Start rollout</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Pause rollout</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Add storage</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item pf-m-current-path">
        <button class="pf-c-menu__item" type="button" aria-expanded="true">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Edit</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
        <div class="pf-c-menu pf-m-drilled-in" id="drilldown-level-4-list-1">
          <div class="pf-c-menu__content">
            <ul class="pf-c-menu__list">
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" tabindex="0">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-left"></i>
                    </span>
                    <span class="pf-c-menu__item-text">Edit</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li class="pf-c-menu__list-item pf-m-current-path">
                <button class="pf-c-menu__item" type="button" aria-expanded="true">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Deployment</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu pf-m-drilled-in" id="drilldown-level-4-list-1-1">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button" tabindex="0">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Deployment</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Routes</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Nodes</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">URLs</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item pf-m-current-path">
                        <button class="pf-c-menu__item" type="button" aria-expanded="true">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Advanced settings</span>
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-right"></i>
                            </span>
                          </div>
                        </button>
                        <div class="pf-c-menu" id="drilldown-level-4-list-1-1-1">
                          <div class="pf-c-menu__content">
                            <ul class="pf-c-menu__list">
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button" tabindex="0">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-toggle-icon">
                                      <i class="fas fa-angle-left"></i>
                                    </span>
                                    <span class="pf-c-menu__item-text">Advanced settings</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-divider" role="separator"></li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Reports</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Policies</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Systems</span>
                                  </div>
                                </button>
                              </li>
                            </ul>
                          </div>
                        </div>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">RBAC</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-level-4-list-1-2">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">RBAC</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Reports</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Policies</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Systems</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Thing with a longer label</span>
                  </div>
                </button>
              </li>
            </ul>
          </div>
        </div>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button" aria-expanded="false">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Configuration</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
        <div class="pf-c-menu" id="drilldown-level-4-list-2">
          <div class="pf-c-menu__content">
            <ul class="pf-c-menu__list">
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-left"></i>
                    </span>
                    <span class="pf-c-menu__item-text">Configuration</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Profile</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-level-4-list-2-1">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Profile</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Avatar</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Name</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Title</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Time zone</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Account settings</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Thing with a longer label</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Edit access settings</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="drilldown-level-4-list-2-2">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Edit access settings</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Global access</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Account access</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </div>
      </li>
    </ul>
  </div>
</div>
```

### Width modified drilldown

```html
<div class="pf-c-menu pf-m-drilldown" style="--pf-c-menu--m-drilldown--Width: 350px;">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Start rollout</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Pause rollout</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Add storage</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button" aria-expanded="false">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Edit</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
        <div class="pf-c-menu" id="-list-1">
          <div class="pf-c-menu__content">
            <ul class="pf-c-menu__list">
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" tabindex="0">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-left"></i>
                    </span>
                    <span class="pf-c-menu__item-text">Edit</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Deployment</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="-list-1-1">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button" tabindex="0">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Deployment</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Routes</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Nodes</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">URLs</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button" aria-expanded="false">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Advanced settings</span>
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-right"></i>
                            </span>
                          </div>
                        </button>
                        <div class="pf-c-menu" id="-list-1-1-1">
                          <div class="pf-c-menu__content">
                            <ul class="pf-c-menu__list">
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button" tabindex="0">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-toggle-icon">
                                      <i class="fas fa-angle-left"></i>
                                    </span>
                                    <span class="pf-c-menu__item-text">Advanced settings</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-divider" role="separator"></li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Reports</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Policies</span>
                                  </div>
                                </button>
                              </li>
                              <li class="pf-c-menu__list-item">
                                <button class="pf-c-menu__item" type="button">
                                  <div class="pf-c-menu__item-main">
                                    <span class="pf-c-menu__item-text">Systems</span>
                                  </div>
                                </button>
                              </li>
                            </ul>
                          </div>
                        </div>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">RBAC</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="-list-1-2">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">RBAC</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Reports</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Policies</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Systems</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Thing with a longer label</span>
                  </div>
                </button>
              </li>
            </ul>
          </div>
        </div>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button" aria-expanded="false">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Configuration</span>
            <span class="pf-c-menu__item-toggle-icon">
              <i class="fas fa-angle-right"></i>
            </span>
          </div>
        </button>
        <div class="pf-c-menu" id="-list-2">
          <div class="pf-c-menu__content">
            <ul class="pf-c-menu__list">
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-left"></i>
                    </span>
                    <span class="pf-c-menu__item-text">Configuration</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Profile</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="-list-2-1">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Profile</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Avatar</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Name</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Title</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Time zone</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Account settings</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Thing with a longer label</span>
                  </div>
                </button>
              </li>
              <li class="pf-c-menu__list-item">
                <button class="pf-c-menu__item" type="button" aria-expanded="false">
                  <div class="pf-c-menu__item-main">
                    <span class="pf-c-menu__item-text">Edit access settings</span>
                    <span class="pf-c-menu__item-toggle-icon">
                      <i class="fas fa-angle-right"></i>
                    </span>
                  </div>
                </button>
                <div class="pf-c-menu" id="-list-2-2">
                  <div class="pf-c-menu__content">
                    <ul class="pf-c-menu__list">
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-toggle-icon">
                              <i class="fas fa-angle-left"></i>
                            </span>
                            <span class="pf-c-menu__item-text">Edit access settings</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-divider" role="separator"></li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Global access</span>
                          </div>
                        </button>
                      </li>
                      <li class="pf-c-menu__list-item">
                        <button class="pf-c-menu__item" type="button">
                          <div class="pf-c-menu__item-main">
                            <span class="pf-c-menu__item-text">Account access</span>
                          </div>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </div>
      </li>
    </ul>
  </div>
</div>
```

### With filtering

```html
<div class="pf-c-menu">
  <div class="pf-c-menu__search">
    <div class="pf-c-menu__search-input">
      <input class="pf-c-form-control pf-m-search" type="search" id="-search-input" name="-search-input" aria-label="Search" />
    </div>
  </div>
  <hr class="pf-c-divider" />
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Action 1</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Action 2</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Action 3</span>
          </div>
        </button>
      </li>
    </ul>
  </div>
</div>
```

### With links

```html
<div class="pf-c-menu">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <a class="pf-c-menu__item" href="#" target="_blank">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Link 1</span>
            <span class="pf-c-menu__item-external-icon">
              <i class="fas fa-external-link-alt" aria-hidden="true"></i>
            </span>
            <span class="pf-screen-reader">(opens new window)</span>
          </div>
        </a>
      </li>
      <li class="pf-c-menu__list-item">
        <a class="pf-c-menu__item" href="#" target="_blank">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Link 2</span>
            <span class="pf-c-menu__item-external-icon">
              <i class="fas fa-external-link-alt" aria-hidden="true"></i>
            </span>
            <span class="pf-screen-reader">(opens new window)</span>
          </div>
        </a>
      </li>
      <li class="pf-c-menu__list-item">
        <a class="pf-c-menu__item" href="#">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Link 3</span>
          </div>
        </a>
      </li>
    </ul>
  </div>
</div>
```

### With separator(s)

```html
<div class="pf-c-menu">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Action 1</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Action 2</span>
          </div>
        </button>
      </li>
      <li class="pf-c-divider" role="separator"></li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Action 3</span>
          </div>
        </button>
      </li>
    </ul>
  </div>
</div>
```

### With titled groups

```html
<div class="pf-c-menu">
  <div class="pf-c-menu__content">
    <section class="pf-c-menu__group">
      <ul class="pf-c-menu__list">
        <li class="pf-c-menu__list-item">
          <a class="pf-c-menu__item" href="#">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Link not in group</span>
            </div>
          </a>
        </li>
      </ul>
    </section>
    <hr class="pf-c-divider" />
    <section class="pf-c-menu__group">
      <h1 class="pf-c-menu__group-title">Group 1</h1>
      <ul class="pf-c-menu__list">
        <li class="pf-c-menu__list-item">
          <a class="pf-c-menu__item" href="#">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Link 1</span>
            </div>
          </a>
        </li>
        <li class="pf-c-menu__list-item">
          <a class="pf-c-menu__item" href="#">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Link 2</span>
            </div>
          </a>
        </li>
      </ul>
    </section>
    <hr class="pf-c-divider" />
    <section class="pf-c-menu__group">
      <h1 class="pf-c-menu__group-title">Group 2</h1>
      <ul class="pf-c-menu__list">
        <li class="pf-c-menu__list-item">
          <a class="pf-c-menu__item" href="#">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Link 1</span>
            </div>
          </a>
        </li>
        <li class="pf-c-menu__list-item">
          <a class="pf-c-menu__item" href="#">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Link 2</span>
            </div>
          </a>
        </li>
      </ul>
    </section>
  </div>
</div>
```

### With description

```html
<div class="pf-c-menu">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-icon">
              <i class="fas fa-fw fa-code-branch" aria-hidden="true"></i>
            </span>
            <span class="pf-c-menu__item-text">Action 1</span>
          </div>
          <div class="pf-c-menu__item-description">Description</div>
        </button>
      </li>
      <li class="pf-c-menu__list-item pf-m-disabled">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-icon">
              <i class="fas fa-fw fa-code-branch" aria-hidden="true"></i>
            </span>
            <span class="pf-c-menu__item-text">Action 2 disabled</span>
          </div>
          <div class="pf-c-menu__item-description">Description</div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-icon">
              <i class="fas fa-fw fa-code-branch" aria-hidden="true"></i>
            </span>
            <span class="pf-c-menu__item-text">Action 3</span>
          </div>
          <div class="pf-c-menu__item-description">Nunc non ornare ex, et pretium dui. Duis nec augue at urna elementum blandit tincidunt eget metus. Aenean sed metus id urna dignissim interdum. Aenean vel nisl vitae arcu vehicula pulvinar eget nec turpis. Cras sit amet est est.</div>
        </button>
      </li>
    </ul>
  </div>
</div>
```

### With actions

```html
<div class="pf-c-menu">
  <div class="pf-c-menu__content">
    <section class="pf-c-menu__group">
      <h1 class="pf-c-menu__group-title">Actions</h1>
      <ul class="pf-c-menu__list">
        <li class="pf-c-menu__list-item">
          <button class="pf-c-menu__item pf-m-selected" type="button">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Item 1</span>
              <span class="pf-c-menu__item-select-icon">
                <i class="fas fa-check" aria-hidden="true"></i>
              </span>
            </div>
            <div class="pf-c-menu__item-description">This is a description</div>
          </button>
          <button class="pf-c-menu__item-action" aria-label="Actions">
            <span class="pf-c-menu__item-action-icon">
              <i class="fas fa-fw fa-ellipsis-v" aria-hidden="true"></i>
            </span>
          </button>
        </li>
        <li class="pf-c-menu__list-item">
          <button class="pf-c-menu__item pf-m-select" type="button">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Item 2</span>
              <span class="pf-c-menu__item-select-icon">
                <i class="fas fa-check" aria-hidden="true"></i>
              </span>
            </div>
          </button>
          <button class="pf-c-menu__item-action" aria-label="Alert">
            <span class="pf-c-menu__item-action-icon">
              <i class="fas fa-fw fa-bell" aria-hidden="true"></i>
            </span>
          </button>
        </li>
        <li class="pf-c-menu__list-item">
          <button class="pf-c-menu__item pf-m-selected" type="button">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Item 3</span>
              <span class="pf-c-menu__item-select-icon">
                <i class="fas fa-check" aria-hidden="true"></i>
              </span>
            </div>
            <div class="pf-c-menu__item-description">This is a description</div>
          </button>
          <button class="pf-c-menu__item-action" aria-label="Copy">
            <span class="pf-c-menu__item-action-icon">
              <i class="fas fa-fw fa-clipboard" aria-hidden="true"></i>
            </span>
          </button>
        </li>
        <li class="pf-c-menu__list-item">
          <button class="pf-c-menu__item pf-m-selected" type="button">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Item 4</span>
              <span class="pf-c-menu__item-select-icon">
                <i class="fas fa-check" aria-hidden="true"></i>
              </span>
            </div>
            <div class="pf-c-menu__item-description">This is a description</div>
          </button>
          <button class="pf-c-menu__item-action" aria-label="Expand">
            <span class="pf-c-menu__item-action-icon">
              <i class="fas fa-fw fa-bars" aria-hidden="true"></i>
            </span>
          </button>
        </li>
      </ul>
    </section>
  </div>
</div>
```

### With favorites

```html
<div class="pf-c-menu">
  <div class="pf-c-menu__content">
    <section class="pf-c-menu__group">
      <h1 class="pf-c-menu__group-title">Favorites</h1>
      <ul class="pf-c-menu__list">
        <li class="pf-c-menu__list-item">
          <a class="pf-c-menu__item" href="#">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Item 1</span>
            </div>
            <div class="pf-c-menu__item-description">This is a description</div>
          </a>
          <button class="pf-c-menu__item-action pf-m-favorite pf-m-favorited" aria-label="Starred">
            <span class="pf-c-menu__item-action-icon">
              <i class="fas fa-star" aria-hidden="true"></i>
            </span>
          </button>
        </li>
        <li class="pf-c-menu__list-item">
          <a class="pf-c-menu__item" href="#" target="_blank">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Item 3</span>
              <span class="pf-c-menu__item-external-icon">
                <i class="fas fa-external-link-alt" aria-hidden="true"></i>
              </span>
              <span class="pf-screen-reader">(opens new window)</span>
            </div>
          </a>
          <button class="pf-c-menu__item-action pf-m-favorite" aria-label="Not starred">
            <span class="pf-c-menu__item-action-icon">
              <i class="fas fa-star" aria-hidden="true"></i>
            </span>
          </button>
        </li>
      </ul>
    </section>
    <hr class="pf-c-divider" />
    <section class="pf-c-menu__group">
      <h1 class="pf-c-menu__group-title">All actions</h1>
      <ul class="pf-c-menu__list">
        <li class="pf-c-menu__list-item">
          <a class="pf-c-menu__item" href="#">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Item 1</span>
            </div>
            <div class="pf-c-menu__item-description">This is a description</div>
          </a>
          <button class="pf-c-menu__item-action pf-m-favorite" aria-label="Not starred">
            <span class="pf-c-menu__item-action-icon">
              <i class="fas fa-star" aria-hidden="true"></i>
            </span>
          </button>
        </li>
        <li class="pf-c-menu__list-item">
          <a class="pf-c-menu__item" href="#" target="_blank">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Item 2</span>
              <span class="pf-c-menu__item-external-icon">
                <i class="fas fa-external-link-alt" aria-hidden="true"></i>
              </span>
              <span class="pf-screen-reader">(opens new window)</span>
            </div>
            <div class="pf-c-menu__item-description">This is a description</div>
          </a>
          <button class="pf-c-menu__item-action pf-m-favorite" aria-label="Not starred">
            <span class="pf-c-menu__item-action-icon">
              <i class="fas fa-star" aria-hidden="true"></i>
            </span>
          </button>
        </li>
        <li class="pf-c-menu__list-item">
          <a class="pf-c-menu__item" href="#" target="_blank">
            <div class="pf-c-menu__item-main">
              <span class="pf-c-menu__item-text">Item 3</span>
              <span class="pf-c-menu__item-external-icon">
                <i class="fas fa-external-link-alt" aria-hidden="true"></i>
              </span>
              <span class="pf-screen-reader">(opens new window)</span>
            </div>
          </a>
          <button class="pf-c-menu__item-action pf-m-favorite" aria-label="Not starred">
            <span class="pf-c-menu__item-action-icon">
              <i class="fas fa-star" aria-hidden="true"></i>
            </span>
          </button>
        </li>
      </ul>
    </section>
  </div>
</div>
```

### Option single select

```html
<div class="pf-c-menu">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Option 1</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Option 2</span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item pf-m-selected" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-icon">
              <i class="fas fa-fw fa-table" aria-hidden="true"></i>
            </span>
            <span class="pf-c-menu__item-text">Option 3</span>
            <span class="pf-c-menu__item-select-icon">
              <i class="fas fa-check" aria-hidden="true"></i>
            </span>
          </div>
          <div class="pf-c-menu__item-description">Description</div>
        </button>
      </li>
    </ul>
  </div>
</div>
```

### Option multi-select

```html
<div class="pf-c-menu">
  <div class="pf-c-menu__content">
    <ul class="pf-c-menu__list">
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item pf-m-selected" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Option 1</span>
            <span class="pf-c-menu__item-select-icon">
              <i class="fas fa-check" aria-hidden="true"></i>
            </span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item pf-m-selected" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-text">Option 2</span>
            <span class="pf-c-menu__item-select-icon">
              <i class="fas fa-check" aria-hidden="true"></i>
            </span>
          </div>
        </button>
      </li>
      <li class="pf-c-menu__list-item">
        <button class="pf-c-menu__item pf-m-selected" type="button">
          <div class="pf-c-menu__item-main">
            <span class="pf-c-menu__item-icon">
              <i class="fas fa-fw fa-table" aria-hidden="true"></i>
            </span>
            <span class="pf-c-menu__item-text">Option 3</span>
            <span class="pf-c-menu__item-select-icon">
              <i class="fas fa-check" aria-hidden="true"></i>
            </span>
          </div>
          <div class="pf-c-menu__item-description">Description</div>
        </button>
      </li>
    </ul>
  </div>
</div>
```

## Documentation

### Overview

### Accessibility

| Attribute                  | Applied                                                                                                                                                   | Outcome                                                                                                        |
| -------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------- |
| `disabled`                 | `button.pf-c-menu__item`                                                                                                                                  | When the menu item uses a button element, indicates that it is unavailable and removes it from keyboard focus. |
| `aria-disabled="true"`     | `a.pf-c-menu__item`                                                                                                                                       | When the menu item uses a link element, removes it from keyboard focus.                                        |
| `tabindex="-1"`            | `a.pf-c-menu__item`                                                                                                                                       | When the menu item uses a link element, removes it from keyboard focus.                                        |
| `aria-hidden="true"`       | `.pf-c-menu__item-icon`, `.pf-c-menu__item-action-icon`, `.pf-c-menu__item-external-icon`, `.pf-c-menu__item-toggle-icon`, `.pf-c-menu__item-select-icon` | Hides the icon from assistive technologies.                                                                    |
| `aria-label="Not starred"` | `.pf-c-menu__item-action-icon.pf-m-favorite`                                                                                                              | Provides an accessible label indicating that the favorite action is not selected.                              |
| `aria-label="Starred"`     | `.pf-c-menu__item-action-icon.pf-m-favorite.pf-m-favorited`                                                                                               | Provides an accessible label indicating that the favorite action is selected.                                  |

### Usage

| Class                                        | Applied to                                                        | Outcome                                                                  |
| -------------------------------------------- | ----------------------------------------------------------------- | ------------------------------------------------------------------------ |
| `.pf-c-menu`                                 | `<div>`                                                           | Initiates the menu. **Required**                                         |
| `.pf-c-menu__search`                         | `<div>`                                                           | Initiates the menu search container. Use for filtering.                  |
| `.pf-c-menu__search-input`                   | `<div>`                                                           | Initiates the menu search input container.                               |
| `.pf-c-menu__content`                        | `<div>`                                                           | Initiates the menu content. Use for lists. **Required**                  |
| `.pf-c-menu__list`                           | `<ul>`                                                            | Initiates the menu list. **Required**                                    |
| `.pf-c-menu__list-item`                      | `<li>`                                                            | Initiates the menu list item. **Required**                               |
| `.pf-c-menu__item`                           | `<button>`, `<a>`, `<div>`                                        | Initiates the menu item. **Required**                                    |
| `.pf-c-menu__item-main`                      | `<div>`                                                           | Initiates the menu item main container. **Required**                     |
| `.pf-c-menu__item-text`                      | `<span>`                                                          | Initiates the menu item text. **Required**                               |
| `.pf-c-menu__item-description`               | `<div>`                                                           | Initiates the menu item description.                                     |
| `.pf-c-menu__item-group`                     | `<section>`                                                       | Initiates the menu item group.                                           |
| `.pf-c-menu__item-group-title`               | `<h1>`                                                            | Initiates the menu item group title.                                     |
| `.pf-c-menu__item-icon`                      | `<span>`                                                          | Initiates the menu item icon.                                            |
| `.pf-c-menu__item-toggle-icon`               | `<span>`                                                          | Initiates the menu item toggle icon.                                     |
| `.pf-c-menu__item-select-icon`               | `<span>`                                                          | Initiates the menu item select icon.                                     |
| `.pf-c-menu__item-action`                    | `<button>`                                                        | Initiates the menu item action.                                          |
| `.pf-c-menu__item-action-icon`               | `<span>`                                                          | Initiates the menu item action icon.                                     |
| `.pf-c-menu__item-external-icon`             | `<span>`                                                          | Initiates the menu item external icon.                                   |
| `.pf-m-favorite`                             | `.pf-c-menu__item-action`                                         | Modifies the menu item action to handle the favorite icon.               |
| `.pf-m-favorited`                            | `.pf-c-menu__item-action.pf-m-favorite`                           | Modifies the menu item action icon to be favorited.                      |
| `.pf-m-selected`                             | `.pf-c-menu__item`                                                | Modifies the menu item to be selected.                                   |
| `.pf-m-flyout`                               | `.pf-c-menu`                                                      | Modifies the menu so that all nested `.pf-c-menu` elements "flyout".     |
| `.pf-m-drilldown`                            | `.pf-c-menu`                                                      | Modifies the menu so that all nested `.pf-c-menu` elements "drill down". |
| `.pf-m-current-path`                         | `.pf-c-menu.pf-m-drilldown .pf-c-menu__list-item`                 | Modifies the menu list item for current path state.                      |
| `.pf-m-drilled-in`                           | `.pf-c-menu.pf-m-drilldown, .pf-c-menu.pf-m-drilldown .pf-c-menu` | Modifies the menu list for drilled in state.                             |
| `--pf-c-menu--m-drilldown--Width: {width}`   | `.pf-c-menu.pf-m-drilldown`                                       | Modifies the width of the drilldown menu. The default value is `auto`.   |
| `--pf-c-menu--m-drilldown--Height: {height}` | `.pf-c-menu.pf-m-drilldown`                                       | Modifies the height of the drilldown menu. The default value is `auto`.  |
