"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

var SkipToContent = function SkipToContent(_ref) {
  var children = _ref.children,
      customClassName = _ref.className,
      href = _ref.href,
      tabIndex = _ref.tabIndex,
      rest = _objectWithoutProperties(_ref, ["children", "className", "href", "tabIndex"]);

  var className = (0, _classnames.default)("".concat(prefix, "--skip-to-content"), customClassName);
  return _react.default.createElement("a", _extends({}, rest, {
    className: className,
    href: href,
    tabIndex: tabIndex
  }), children);
};

SkipToContent.propTypes = {
  /**
   * Provide an optional class to be applied to the containing node
   */
  children: _propTypes.default.string.isRequired,

  /**
   * Provide the `href` to the id of the element on your package that is the
   * main content.
   */
  href: _propTypes.default.string.isRequired,

  /**
   * Optionally override the default tabindex of 0
   */
  tabIndex: _propTypes.default.string.isRequired
};
SkipToContent.defaultProps = {
  children: 'Skip to main content',
  href: '#main-content',
  tabIndex: '0'
};
var _default = SkipToContent;
exports.default = _default;