---
id: Box shadow
section: utilities
---import './box-shadow.css'

## Examples

### Small

```html
<div class="pf-u-box-shadow-sm">Regular</div>
<div class="pf-u-box-shadow-sm-top">Top</div>
<div class="pf-u-box-shadow-sm-right">Right</div>
<div class="pf-u-box-shadow-sm-bottom">Bottom</div>
<div class="pf-u-box-shadow-sm-left">Left</div>
```

### Medium

```html
<div class="pf-u-box-shadow-md">Regular</div>
<div class="pf-u-box-shadow-md-top">Top</div>
<div class="pf-u-box-shadow-md-right">Right</div>
<div class="pf-u-box-shadow-md-bottom">Bottom</div>
<div class="pf-u-box-shadow-md-left">Left</div>
```

### Large

```html
<div class="pf-u-box-shadow-lg">Regular</div>
<div class="pf-u-box-shadow-lg-top">Top</div>
<div class="pf-u-box-shadow-lg-right">Right</div>
<div class="pf-u-box-shadow-lg-bottom">Bottom</div>
<div class="pf-u-box-shadow-lg-left">Left</div>
```

### Extra large

```html
<div class="pf-u-box-shadow-xl">Regular</div>
<div class="pf-u-box-shadow-xl-top">Top</div>
<div class="pf-u-box-shadow-xl-right">Right</div>
<div class="pf-u-box-shadow-xl-bottom">Bottom</div>
<div class="pf-u-box-shadow-xl-left">Left</div>
```

### Inset

```html
<div class="pf-u-box-shadow-inset">Regular</div>
```

## Documentation

### Overview

Box shadow utility

### Usage

| Class                        | Applied to | Outcome                            |
| ---------------------------- | ---------- | ---------------------------------- |
| `.pf-u-box-shadow-sm`        | `*`        | Applies box-shadow small.          |
| `.pf-u-box-shadow-sm-top`    | `*`        | Applies box-shadow small top.      |
| `.pf-u-box-shadow-sm-right`  | `*`        | Applies box-shadow small right.    |
| `.pf-u-box-shadow-sm-bottom` | `*`        | Applies box-shadow small bottom.   |
| `.pf-u-box-shadow-sm-left`   | `*`        | Applies box-shadow small left.     |
| `.pf-u-box-shadow-md`        | `*`        | Applies box-shadow medium.         |
| `.pf-u-box-shadow-md-top`    | `*`        | Applies box-shadow medium top.     |
| `.pf-u-box-shadow-md-right`  | `*`        | Applies box-shadow medium right.   |
| `.pf-u-box-shadow-md-bottom` | `*`        | Applies box-shadow medium bottom.  |
| `.pf-u-box-shadow-md-left`   | `*`        | Applies box-shadow medium left.    |
| `.pf-u-box-shadow-lg`        | `*`        | Applies box-shadow large.          |
| `.pf-u-box-shadow-lg-top`    | `*`        | Applies box-shadow large top.      |
| `.pf-u-box-shadow-lg-right`  | `*`        | Applies box-shadow large right.    |
| `.pf-u-box-shadow-lg-bottom` | `*`        | Applies box-shadow large bottom.   |
| `.pf-u-box-shadow-lg-left`   | `*`        | Applies box-shadow large left.     |
| `.pf-u-box-shadow-xl`        | `*`        | Applies box-shadow x-large.        |
| `.pf-u-box-shadow-xl-top`    | `*`        | Applies box-shadow x-large top.    |
| `.pf-u-box-shadow-xl-right`  | `*`        | Applies box-shadow x-large right.  |
| `.pf-u-box-shadow-xl-bottom` | `*`        | Applies box-shadow x-large bottom. |
| `.pf-u-box-shadow-xl-left`   | `*`        | Applies box-shadow x-large left.   |
