"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasChildren = exports.isComment = exports.isText = exports.isCDATA = exports.isTag = void 0;
var domelementtype_1 = require("domelementtype");
/**
 * @param node Node to check.
 * @returns `true` if the node is a `Element`, `false` otherwise.
 */
function isTag(node) {
    return domelementtype_1.isTag(node);
}
exports.isTag = isTag;
/**
 * @param node Node to check.
 * @returns `true` if the node is a `NodeWithChildren`, `false` otherwise.
 */
function isCDATA(node) {
    return node.type === "cdata" /* CDATA */;
}
exports.isCDATA = isCDATA;
/**
 * @param node Node to check.
 * @returns `true` if the node is a `DataNode`, `false` otherwise.
 */
function isText(node) {
    return node.type === "text" /* Text */;
}
exports.isText = isText;
/**
 * @param node Node to check.
 * @returns `true` if the node is a `DataNode`, `false` otherwise.
 */
function isComment(node) {
    return node.type === "comment" /* Comment */;
}
exports.isComment = isComment;
/**
 * @param node Node to check.
 * @returns `true` if the node is a `NodeWithChildren` (has children), `false` otherwise.
 */
function hasChildren(node) {
    return Object.prototype.hasOwnProperty.call(node, "children");
}
exports.hasChildren = hasChildren;
