# coffeeify [![Build Status](https://travis-ci.org/jnordberg/coffeeify.svg?branch=master)](https://travis-ci.org/jnordberg/coffeeify)

CoffeeScript browserify transform. Mix and match `.coffee` and `.js` files in the same project.

**NOTE: As of version 3.0.0 coffeeify requires CoffeeScript to be installed manually as a peerDependency, also note that the CoffeeScript package has changed name from `coffee-script` to `coffeescript`.**

## Example

Given some files written in a mix of `js` and `coffee`:

foo.coffee:

```coffee
console.log require './bar.js'
```

bar.js:

```javascript
module.exports = require('./baz.coffee')(5)
```

baz.coffee:

```coffee
module.exports = (n) -> n ** n
```

Install coffeeify into your app, and CoffeeScript if you don't have it already:

```
$ npm install --save-dev coffeeify coffeescript
```

When you compile your app, just pass `-t coffeeify` to browserify:

```shell
$ browserify -t coffeeify foo.coffee > bundle.js
$ node bundle.js
3125
```

You can omit the `.coffee` extension from your requires if you add the extension to browserify's module extensions:

```javascript
module.exports = require('./baz')(5)
```

```
$ browserify -t coffeeify --extension=".coffee" foo.coffee > bundle.js
$ node bundle.js
3125
```

You can also pass options to the CoffeeScript compiler:

```
$ browserify -t [ coffeeify --bare false --header true ] --extension=".coffee" foo.coffee
..
// Generated by CoffeeScript 1.10.0
(function() {
  console.log(require('./bar.js'));

}).call(this);
..
```

## Options

Name       | Default   | Description
-----------|-----------|-------------------------------------------------------------------------------------------
sourceMap  | `null`    | Generate source maps, deteremined from browserify's `--debug` option if not set.
bare       | `true`    | Omit the `(function(){ .. }).call(this);` wrapper.
header     | `false`   | Include the `// Generated by CoffeeScript <version>` header in every file processed.

When using browserify programatically options can be passed as an object, example:

```coffee
browserify = require 'browserify'
coffeeify = require 'coffeeify'

bundle = browserify
  extensions: ['.coffee']

bundle.transform coffeeify,
  bare: false
  header: true

bundle.add 'foo.coffee'

bundle.bundle (error, result) ->
  throw error if error?
  process.stdout.write result
```

## Install

With [npm](https://npmjs.org) do:

```bash
npm install --save-dev coffeeify
```

CoffeeScript is not installed automatically, so that you can choose what version of CoffeeScript you'd like:

```bash
npm install --save-dev coffeescript  # Or coffeescript@1 to use CoffeeScript 1.x
```

## License

MIT
