"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartBar = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_bar_1 = require("victory-bar");
const ChartContainer_1 = require("../ChartContainer");
const ChartUtils_1 = require("../ChartUtils");
exports.ChartBar = (_a) => {
    var { containerComponent = React.createElement(ChartContainer_1.ChartContainer, null), themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant) } = _a, rest = tslib_1.__rest(_a, ["containerComponent", "themeColor", "themeVariant", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ theme }, containerComponent.props));
    // Note: containerComponent is required for theme
    return React.createElement(victory_bar_1.VictoryBar, Object.assign({ containerComponent: container, theme: theme }, rest));
};
exports.ChartBar.displayName = 'ChartBar';
// Note: VictoryBar.getDomain & VictoryBar.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartBar, victory_bar_1.VictoryBar);
//# sourceMappingURL=ChartBar.js.map