import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { Helpers } from 'victory-core';
import { VictoryLegend } from 'victory-legend';
import { ChartLabel } from '../ChartLabel';
import { ChartLegend } from '../ChartLegend';
import { ChartLegendTooltipLabel } from './ChartLegendTooltipLabel';
import { ChartLegendTooltipStyles } from '../ChartTheme';
import { getLegendTooltipDataProps, getLegendTooltipSize, getLegendTooltipVisibleData, getLegendTooltipVisibleText, getTheme } from '../ChartUtils';
export const ChartLegendTooltipContent = (_a) => {
    var { activePoints, center, datum, dx = 0, dy = 0, flyoutHeight, flyoutWidth, height, labelComponent = React.createElement(ChartLegendTooltipLabel, null), legendComponent = React.createElement(ChartLegend, null), legendData, text, themeColor, themeVariant, title, titleComponent = React.createElement(ChartLabel, null), width, 
    // destructure last
    theme = getTheme(themeColor, themeVariant) } = _a, rest = __rest(_a, ["activePoints", "center", "datum", "dx", "dy", "flyoutHeight", "flyoutWidth", "height", "labelComponent", "legendComponent", "legendData", "text", "themeColor", "themeVariant", "title", "titleComponent", "width", "theme"]);
    const pointerLength = theme && theme.tooltip ? Helpers.evaluateProp(theme.tooltip.pointerLength) : 10;
    const legendProps = getLegendTooltipDataProps(legendComponent.props);
    const visibleLegendData = getLegendTooltipVisibleData({
        activePoints,
        colorScale: legendProps.colorScale,
        legendData,
        text,
        theme
    });
    // Component offsets
    const legendOffsetX = 0;
    const legendOffsetY = title ? 5 : -10;
    const titleOffsetX = 10;
    const titleOffsetY = 0;
    // Returns x position of flyout
    const getX = () => {
        if (!(center || flyoutWidth || width)) {
            const x = rest.x;
            return x ? x : undefined;
        }
        const _flyoutWidth = Helpers.evaluateProp(flyoutWidth);
        if (width > center.x + _flyoutWidth + pointerLength) {
            return center.x + ChartLegendTooltipStyles.flyout.padding / 2;
        }
        else if (center.x < _flyoutWidth + pointerLength) {
            return ChartLegendTooltipStyles.flyout.padding / 2 - pointerLength;
        }
        else {
            return center.x - _flyoutWidth;
        }
    };
    // Returns y position
    const getY = () => {
        if (!(center || flyoutHeight || height)) {
            const y = rest.y;
            return y ? y : undefined;
        }
        const _flyoutHeight = Helpers.evaluateProp(flyoutHeight);
        if (center.y < _flyoutHeight / 2) {
            return ChartLegendTooltipStyles.flyout.padding / 2;
        }
        else if (center.y > height - _flyoutHeight / 2) {
            return height - _flyoutHeight + ChartLegendTooltipStyles.flyout.padding / 2;
        }
        else {
            return center.y - _flyoutHeight / 2 + ChartLegendTooltipStyles.flyout.padding / 2;
        }
    };
    // Min & max dimensions do not include flyout padding
    const maxLegendDimensions = getLegendTooltipSize({
        legendData: visibleLegendData,
        legendProps,
        text: getLegendTooltipVisibleText({ activePoints, legendData, text }),
        theme
    });
    const minLegendDimensions = getLegendTooltipSize({
        legendData: [{ name: '' }],
        legendProps,
        theme
    });
    // Returns the label component
    const getLabelComponent = () => React.cloneElement(labelComponent, Object.assign({ dx: maxLegendDimensions.width - minLegendDimensions.width, legendData: visibleLegendData }, labelComponent.props));
    // Returns the title component
    const getTitleComponent = () => {
        const _title = title instanceof Function ? title(datum) : title;
        return React.cloneElement(titleComponent, Object.assign({ style: {
                fill: ChartLegendTooltipStyles.label.fill,
                fontWeight: ChartLegendTooltipStyles.label.fontWeight
            }, text: _title, textAnchor: 'start', x: getX() + titleOffsetX + Helpers.evaluateProp(dx), y: getY() + titleOffsetY + Helpers.evaluateProp(dy) }, titleComponent.props));
    };
    // Returns the legebd component
    const getLegendComponent = () => React.cloneElement(legendComponent, Object.assign({ data: getLegendTooltipVisibleData({
            activePoints,
            colorScale: legendProps.colorScale,
            legendData,
            text,
            textAsLegendData: true,
            theme
        }), labelComponent: getLabelComponent(), standalone: false, theme, x: getX() + legendOffsetX + Helpers.evaluateProp(dx), y: getY() + legendOffsetY + Helpers.evaluateProp(dy) }, legendProps));
    return (React.createElement(React.Fragment, null,
        getTitleComponent(),
        getLegendComponent()));
};
ChartLegendTooltipContent.displayName = 'ChartLegendTooltipContent';
// Note: VictoryLegend.role must be hoisted, but getBaseProps causes error with ChartVoronoiContainer
hoistNonReactStatics(ChartLegendTooltipContent, VictoryLegend, { getBaseProps: true });
//# sourceMappingURL=ChartLegendTooltipContent.js.map