"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BulletStyles = void 0;
const tslib_1 = require("tslib");
/* eslint-disable camelcase */
const chart_bullet_axis_tick_count_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_axis_tick_count'));
const chart_bullet_comparative_measure_Width_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_Width'));
const chart_bullet_comparative_measure_error_Width_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_error_Width'));
const chart_bullet_comparative_measure_warning_Width_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_warning_Width'));
const chart_bullet_label_subtitle_Fill_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_label_subtitle_Fill'));
const chart_bullet_primary_measure_dot_size_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_primary_measure_dot_size'));
const chart_bullet_primary_measure_segmented_Width_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_primary_measure_segmented_Width'));
const chart_bullet_qualitative_range_Width_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_qualitative_range_Width'));
const chart_global_FontSize_2xl_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_global_FontSize_2xl'));
const chart_global_FontSize_sm_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_global_FontSize_sm'));
const chart_global_FontSize_lg_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_global_FontSize_lg'));
// Bullet styles
exports.BulletStyles = {
    axisTickCount: chart_bullet_axis_tick_count_1.default.value,
    comparativeMeasureErrorWidth: chart_bullet_comparative_measure_error_Width_1.default.value,
    comparativeMeasureWarningWidth: chart_bullet_comparative_measure_warning_Width_1.default.value,
    comparativeMeasureWidth: chart_bullet_comparative_measure_Width_1.default.value,
    label: {
        groupTitle: {
            // Victory props only
            fontSize: chart_global_FontSize_2xl_1.default.value
        },
        subTitle: {
            // Victory props only
            fill: chart_bullet_label_subtitle_Fill_1.default.value,
            fontSize: chart_global_FontSize_sm_1.default.value
        },
        title: {
            // Victory props only
            fontSize: chart_global_FontSize_lg_1.default.value
        }
    },
    primaryDotMeasureSize: chart_bullet_primary_measure_dot_size_1.default.value,
    primarySegmentedMeasureWidth: chart_bullet_primary_measure_segmented_Width_1.default.value,
    qualitativeRangeWidth: chart_bullet_qualitative_range_Width_1.default.value
};
//# sourceMappingURL=bullet-styles.js.map