# Go API client for openapi

APPR API documentation 

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 0.2.6
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```shell
go get github.com/stretchr/testify/assert
go get golang.org/x/oauth2
go get golang.org/x/net/context
go get github.com/antihax/optional
```

Put the package under your project folder and add the following in import:

```golang
import "./openapi"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost:5000*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BlobsApi* | [**PullBlob**](docs/BlobsApi.md#pullblob) | **Get** /api/v1/packages/{namespace}/{package}/blobs/sha256/{digest} | Pull a package blob by digest
*BlobsApi* | [**PullBlobJson**](docs/BlobsApi.md#pullblobjson) | **Get** /api/v1/packages/{namespace}/{package}/blobs/sha256/{digest}/json | Pull a package blob by digest
*BlobsApi* | [**PullPackage**](docs/BlobsApi.md#pullpackage) | **Get** /api/v1/packages/{namespace}/{package}/{release}/{media_type}/pull | Download the package
*BlobsApi* | [**PullPackageJson**](docs/BlobsApi.md#pullpackagejson) | **Get** /api/v1/packages/{namespace}/{package}/{release}/{media_type}/pull/json | Download the package
*ChannelApi* | [**CreateChannel**](docs/ChannelApi.md#createchannel) | **Post** /api/v1/packages/{namespace}/{package}/channels | Create a new channel
*ChannelApi* | [**CreateChannelRelease**](docs/ChannelApi.md#createchannelrelease) | **Post** /api/v1/packages/{namespace}/{package}/channels/{channel}/{release} | Add a release to a channel
*ChannelApi* | [**DeleteChannel**](docs/ChannelApi.md#deletechannel) | **Delete** /api/v1/packages/{namespace}/{package}/channels/{channel} | Delete channel
*ChannelApi* | [**DeleteChannelRelease**](docs/ChannelApi.md#deletechannelrelease) | **Delete** /api/v1/packages/{namespace}/{package}/channels/{channel}/{release} | Remove a release from the channel
*ChannelApi* | [**ListChannels**](docs/ChannelApi.md#listchannels) | **Get** /api/v1/packages/{namespace}/{package}/channels | List channels
*ChannelApi* | [**ShowChannel**](docs/ChannelApi.md#showchannel) | **Get** /api/v1/packages/{namespace}/{package}/channels/{channel} | show channel
*InfoApi* | [**GetVersion**](docs/InfoApi.md#getversion) | **Get** /version | Display api version
*PackageApi* | [**CreatePackage**](docs/PackageApi.md#createpackage) | **Post** /api/v1/packages | Push new package release to the registry
*PackageApi* | [**DeletePackage**](docs/PackageApi.md#deletepackage) | **Delete** /api/v1/packages/{namespace}/{package}/{release}/{media_type} | Delete a package release
*PackageApi* | [**ListPackages**](docs/PackageApi.md#listpackages) | **Get** /api/v1/packages | List packages
*PackageApi* | [**PullPackage**](docs/PackageApi.md#pullpackage) | **Get** /api/v1/packages/{namespace}/{package}/{release}/{media_type}/pull | Download the package
*PackageApi* | [**PullPackageJson**](docs/PackageApi.md#pullpackagejson) | **Get** /api/v1/packages/{namespace}/{package}/{release}/{media_type}/pull/json | Download the package
*PackageApi* | [**ShowPackage**](docs/PackageApi.md#showpackage) | **Get** /api/v1/packages/{namespace}/{package}/{release}/{media_type} | Show a package
*PackageApi* | [**ShowPackageManifests**](docs/PackageApi.md#showpackagemanifests) | **Get** /api/v1/packages/{namespace}/{package}/{release} | List all manifests for a package
*PackageApi* | [**ShowPackageReleases**](docs/PackageApi.md#showpackagereleases) | **Get** /api/v1/packages/{namespace}/{package} | List all releases for a package


## Documentation For Models

 - [Channel](docs/Channel.md)
 - [Error](docs/Error.md)
 - [Manifest](docs/Manifest.md)
 - [OciDescriptor](docs/OciDescriptor.md)
 - [Package](docs/Package.md)
 - [PackageDescription](docs/PackageDescription.md)
 - [PostPackage](docs/PostPackage.md)
 - [PullJson](docs/PullJson.md)
 - [Version](docs/Version.md)


## Documentation For Authorization

 Endpoints do not require authorization.


## Author



