// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/type/v3/token_bucket.proto

package envoy_type_v3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/golang/protobuf/ptypes"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = ptypes.DynamicAny{}
)

// Validate checks the field values on TokenBucket with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *TokenBucket) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetMaxTokens() <= 0 {
		return TokenBucketValidationError{
			field:  "MaxTokens",
			reason: "value must be greater than 0",
		}
	}

	if wrapper := m.GetTokensPerFill(); wrapper != nil {

		if wrapper.GetValue() <= 0 {
			return TokenBucketValidationError{
				field:  "TokensPerFill",
				reason: "value must be greater than 0",
			}
		}

	}

	if m.GetFillInterval() == nil {
		return TokenBucketValidationError{
			field:  "FillInterval",
			reason: "value is required",
		}
	}

	if d := m.GetFillInterval(); d != nil {
		dur, err := ptypes.Duration(d)
		if err != nil {
			return TokenBucketValidationError{
				field:  "FillInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return TokenBucketValidationError{
				field:  "FillInterval",
				reason: "value must be greater than 0s",
			}
		}

	}

	return nil
}

// TokenBucketValidationError is the validation error returned by
// TokenBucket.Validate if the designated constraints aren't met.
type TokenBucketValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TokenBucketValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TokenBucketValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TokenBucketValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TokenBucketValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TokenBucketValidationError) ErrorName() string { return "TokenBucketValidationError" }

// Error satisfies the builtin error interface
func (e TokenBucketValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTokenBucket.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TokenBucketValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TokenBucketValidationError{}
