/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { eventBus } from '@kui-shell/core';
import KuiContext from './context';
import Block from '../Views/Terminal/Block';
import { Active } from '../Views/Terminal/Block/BlockModel';
import '../../../web/css/static/InputStripe.scss';
export default class InputStripe extends React.PureComponent {
    constructor(props) {
        super(props);
        eventBus.onCommandComplete(this.props.uuid, this.onOutputRender.bind(this));
        this.state = {
            idx: 0,
            model: Active()
        };
    }
    /** Command has completed in our tab */
    onOutputRender() {
        this.setState(curState => ({ idx: curState.idx + 1, model: Active() }));
    }
    render() {
        return (React.createElement(KuiContext.Provider, { value: { prompt: this.props.prompt || '\u276f' } },
            React.createElement("div", { className: "kui--input-stripe repl" },
                React.createElement(Block, { idx: this.state.idx, uuid: this.props.uuid, tab: this.props.tab, model: this.state.model, noOutput: true, noPromptContext: true, promptPlaceholder: this.props.promptPlaceholder }, this.props.children))));
    }
}
//# sourceMappingURL=InputStripe.js.map