import * as React from 'react';
import { ToolbarText, ToolbarAlert, Button } from '@kui-shell/core';
import { Props as ToolbarProps } from './Toolbar';
export { Props as ToolbarContainerProps };
export declare type Props = React.PropsWithChildren<ToolbarProps>;
interface State {
    toolbarText: ToolbarText;
    extraButtons?: Button[];
    extraButtonsOverride?: boolean;
    alerts?: ToolbarAlert[];
}
export default class ToolbarContainer extends React.PureComponent<Props, State> {
    constructor(props: Props);
    /** Called by children if they desire an update to the Toolbar */
    private onToolbarUpdate;
    /** Graft on the toolbar event management */
    private children;
    render(): JSX.Element;
}
