/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, waitForRed, defaultModeForGet, createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubectl/tests/lib/k8s/utils';
import { dirname } from 'path';
const ROOT = dirname(require.resolve('@kui-shell/plugin-kubectl/tests/package.json'));
const synonyms = ['kubectl'];
describe(`kubectl create hpa HorizontalPodAutoscaler ${process.env.MOCHA_RUN_TARGET ||
    ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    // repeat the tests for kubectl, k, etc. i.e. any built-in
    // synonyms/aliases we have for "kubectl"
    synonyms.forEach(kubectl => {
        const ns = createNS();
        const inNamespace = `-n ${ns}`;
        allocateNS(this, ns);
        it(`should create a HorizontalPodAutoscaler hpa via ${kubectl}`, () => __awaiter(this, void 0, void 0, function* () {
            try {
                const selector = yield CLI.command(`${kubectl} apply -f "${ROOT}/data/k8s/hpa.yaml" ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({
                    selector: Selectors.BY_NAME('travelapp-hpa')
                }));
                // wait for the badge to become green
                yield waitForGreen(this.app, selector);
                // now click on the table row
                yield this.app.client.click(`${selector} .clickable`);
                yield SidecarExpect.open(this.app)
                    .then(SidecarExpect.mode(defaultModeForGet))
                    .then(SidecarExpect.showing('travelapp-hpa'));
            }
            catch (err) {
                return Common.oops(this, true)(err);
            }
        }));
        it(`should delete the HorizontalPodAutoscaler hpa from URL via ${kubectl}`, () => {
            return CLI.command(`${kubectl} delete -f "${ROOT}/data/k8s/hpa.yaml" ${inNamespace}`, this.app)
                .then(ReplExpect.okWithCustom({
                selector: Selectors.BY_NAME('travelapp-hpa')
            }))
                .then(selector => waitForRed(this.app, selector))
                .catch(Common.oops(this, true));
        });
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=hpa.js.map