"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _pluginClientCommon = require("@kui-shell/plugin-client-common");

var _proxy = require("@kui-shell/client/config.d/proxy.json");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-proxy-support');
/** class designation for our offline indicator */

const buttonDesignation = 'kui--plugin-bash-like--pty-offline-indicator';

class ProxyOfflineIndicator extends React.PureComponent {
  constructor(props) {
    super(props);
    const proxyEnabled = !_proxy.proxyServer['enabled'] || _proxy.proxyServer['enabled'] !== false;
    this.state = {
      proxyEnabled,
      offline: true
    };

    _core.eventChannelUnsafe.on('/proxy/online', () => this.setState({
      offline: false
    }));

    _core.eventChannelUnsafe.on('/proxy/offline', () => this.setState({
      offline: true
    }));
  }
  /** If the proxy is enabled, and we are offline, then render a widget indicating such. */


  render() {
    if (!this.state.proxyEnabled || !this.state.offline || !(0, _core.inBrowser)()) {
      return React.createElement(React.Fragment, null);
    } else {
      return React.createElement(_pluginClientCommon.TagWidget, {
        id: buttonDesignation,
        type: "error"
      }, strings('Offline'));
    }
  }

}

exports.default = ProxyOfflineIndicator;