import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Drawer/drawer';
import { css } from '@patternfly/react-styles';
import { DrawerContext } from './Drawer';
import { formatBreakpointMods } from '../../helpers/util';
export const DrawerPanelContent = (_a) => {
    var { className = '', children, hasNoBorder = false, widths } = _a, props = __rest(_a, ["className", "children", "hasNoBorder", "widths"]);
    return (React.createElement(DrawerContext.Consumer, null, ({ isExpanded, isStatic }) => (React.createElement("div", Object.assign({ className: css(styles.drawerPanel, hasNoBorder && styles.modifiers.noBorder, formatBreakpointMods(widths, styles), className), hidden: isStatic ? false : !isExpanded }, props), children))));
};
//# sourceMappingURL=DrawerPanelContent.js.map