"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const select_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Select/select"));
const form_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Form/form"));
const react_styles_1 = require("@patternfly/react-styles");
const SelectOption_1 = require("./SelectOption");
const selectConstants_1 = require("./selectConstants");
const helpers_1 = require("../../helpers");
class SelectMenu extends React.Component {
    extendChildren() {
        const { children, isGrouped } = this.props;
        const childrenArray = children;
        if (isGrouped) {
            let index = 0;
            return React.Children.map(childrenArray, (group) => React.cloneElement(group, {
                titleId: group.props.label.replace(/\W/g, '-'),
                children: group.props.children.map((option) => this.cloneOption(option, index++))
            }));
        }
        return React.Children.map(childrenArray, (child, index) => this.cloneOption(child, index));
    }
    cloneOption(child, index) {
        const { selected, sendRef, keyHandler } = this.props;
        const isSelected = selected && selected.constructor === Array
            ? selected && (Array.isArray(selected) && selected.includes(child.props.value))
            : selected === child.props.value;
        return React.cloneElement(child, {
            id: `${child.props.value ? child.props.value.toString() : ''}-${index}`,
            isSelected,
            sendRef,
            keyHandler,
            index
        });
    }
    extendCheckboxChildren(children) {
        const { isGrouped, checked, sendRef, keyHandler, hasInlineFilter } = this.props;
        let index = hasInlineFilter ? 1 : 0;
        if (isGrouped) {
            return React.Children.map(children, (group) => {
                if (group.type === SelectOption_1.SelectOption) {
                    return group;
                }
                return React.cloneElement(group, {
                    titleId: group.props.label.replace(/\W/g, '-'),
                    children: (React.createElement("fieldset", { "aria-labelledby": group.props.label.replace(/\W/g, '-'), className: react_styles_1.css(select_1.default.selectMenuFieldset) }, group.props.children.map((option) => React.cloneElement(option, {
                        isChecked: checked && checked.includes(option.props.value),
                        sendRef,
                        keyHandler,
                        index: index++
                    }))))
                });
            });
        }
        return React.Children.map(children, (child) => React.cloneElement(child, {
            isChecked: checked && checked.includes(child.props.value),
            sendRef,
            keyHandler,
            index: index++
        }));
    }
    render() {
        /* eslint-disable @typescript-eslint/no-unused-vars */
        const _a = this.props, { children, isCustomContent, className, isExpanded, openedOnEnter, selected, checked, isGrouped, sendRef, keyHandler, maxHeight, noResultsFoundText, createText, 'aria-label': ariaLabel, 'aria-labelledby': ariaLabelledBy, hasInlineFilter } = _a, props = tslib_1.__rest(_a, ["children", "isCustomContent", "className", "isExpanded", "openedOnEnter", "selected", "checked", "isGrouped", "sendRef", "keyHandler", "maxHeight", "noResultsFoundText", "createText", 'aria-label', 'aria-labelledby', "hasInlineFilter"]);
        /* eslint-enable @typescript-eslint/no-unused-vars */
        return (React.createElement(selectConstants_1.SelectConsumer, null, ({ variant }) => (React.createElement(React.Fragment, null,
            isCustomContent && (React.createElement("div", Object.assign({ className: react_styles_1.css(select_1.default.selectMenu, className) }, (maxHeight && { style: { maxHeight, overflow: 'auto' } }), props), children)),
            variant !== selectConstants_1.SelectVariant.checkbox && !isCustomContent && (React.createElement("ul", Object.assign({ className: react_styles_1.css(select_1.default.selectMenu, className), role: "listbox" }, (maxHeight && { style: { maxHeight, overflow: 'auto' } }), props), this.extendChildren())),
            variant === selectConstants_1.SelectVariant.checkbox && !isCustomContent && React.Children.count(children) > 0 && (React.createElement(helpers_1.FocusTrap, { focusTrapOptions: { clickOutsideDeactivates: true } },
                React.createElement("div", Object.assign({ className: react_styles_1.css(select_1.default.selectMenu, className) }, (maxHeight && { style: { maxHeight, overflow: 'auto' } })),
                    React.createElement("fieldset", Object.assign({}, props, { "aria-label": ariaLabel, "aria-labelledby": (!ariaLabel && ariaLabelledBy) || null, className: react_styles_1.css(form_1.default.formFieldset) }),
                        hasInlineFilter && [
                            children.shift(),
                            ...this.extendCheckboxChildren(children)
                        ],
                        !hasInlineFilter && this.extendCheckboxChildren(children))))),
            variant === selectConstants_1.SelectVariant.checkbox && !isCustomContent && React.Children.count(children) === 0 && (React.createElement("div", Object.assign({ className: react_styles_1.css(select_1.default.selectMenu, className) }, (maxHeight && { style: { maxHeight, overflow: 'auto' } })),
                React.createElement("fieldset", { className: react_styles_1.css(select_1.default.selectMenuFieldset) })))))));
    }
}
exports.SelectMenu = SelectMenu;
SelectMenu.defaultProps = {
    className: '',
    isExpanded: false,
    isGrouped: false,
    openedOnEnter: false,
    selected: '',
    maxHeight: '',
    sendRef: () => { },
    keyHandler: () => { },
    isCustomContent: false,
    hasInlineFilter: false
};
//# sourceMappingURL=SelectMenu.js.map