"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var _toggleClass = _interopRequireDefault(require("../../tools/toggleClass"));

var _Button = _interopRequireDefault(require("../Button"));

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _requiredIfGivenPropExists = _interopRequireDefault(require("../../prop-types/requiredIfGivenPropExists"));

var _wrapFocus = _interopRequireWildcard(require("../../internal/wrapFocus"));

var _setupGetInstanceId = _interopRequireDefault(require("../../tools/setupGetInstanceId"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var prefix = _carbonComponents.settings.prefix;
var getInstanceId = (0, _setupGetInstanceId.default)();

var Modal =
/*#__PURE__*/
function (_Component) {
  _inherits(Modal, _Component);

  function Modal() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, Modal);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(Modal)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "button", _react.default.createRef());

    _defineProperty(_assertThisInitialized(_this), "outerModal", _react.default.createRef());

    _defineProperty(_assertThisInitialized(_this), "innerModal", _react.default.createRef());

    _defineProperty(_assertThisInitialized(_this), "startTrap", _react.default.createRef());

    _defineProperty(_assertThisInitialized(_this), "endTrap", _react.default.createRef());

    _defineProperty(_assertThisInitialized(_this), "modalInstanceId", "modal-".concat(getInstanceId()));

    _defineProperty(_assertThisInitialized(_this), "modalLabelId", "".concat(prefix, "--modal-header__label--").concat(_this.modalInstanceId));

    _defineProperty(_assertThisInitialized(_this), "modalHeadingId", "".concat(prefix, "--modal-header__heading--").concat(_this.modalInstanceId));

    _defineProperty(_assertThisInitialized(_this), "handleKeyDown", function (evt) {
      if (_this.props.open) {
        if (evt.which === 27) {
          _this.props.onRequestClose(evt);
        }

        if (evt.which === 13 && _this.props.shouldSubmitOnEnter) {
          _this.props.onRequestSubmit(evt);
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleMousedown", function (evt) {
      if (_this.innerModal.current && !_this.innerModal.current.contains(evt.target) && !(0, _wrapFocus.elementOrParentIsFloatingMenu)(evt.target, _this.props.selectorsFloatingMenus)) {
        _this.props.onRequestClose(evt);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleBlur", function (_ref) {
      var oldActiveNode = _ref.target,
          currentActiveNode = _ref.relatedTarget;
      var _this$props = _this.props,
          open = _this$props.open,
          selectorsFloatingMenus = _this$props.selectorsFloatingMenus;

      if (open && currentActiveNode && oldActiveNode) {
        var modalNode = _this.innerModal.current;
        var startTrapNode = _this.startTrap.current;
        var endTrapNode = _this.endTrap.current;
        (0, _wrapFocus.default)({
          modalNode: modalNode,
          startTrapNode: startTrapNode,
          endTrapNode: endTrapNode,
          currentActiveNode: currentActiveNode,
          oldActiveNode: oldActiveNode,
          selectorsFloatingMenus: selectorsFloatingMenus
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "initialFocus", function (focusContainerElement) {
      var containerElement = focusContainerElement || _this.innerModal.current;
      var primaryFocusElement = containerElement ? containerElement.querySelector(_this.props.selectorPrimaryFocus) : null;

      if (primaryFocusElement) {
        return primaryFocusElement;
      }

      return _this.button && _this.button.current;
    });

    _defineProperty(_assertThisInitialized(_this), "focusButton", function (focusContainerElement) {
      var target = _this.initialFocus(focusContainerElement);

      if (target) {
        target.focus();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleTransitionEnd", function (evt) {
      if (evt.target === evt.currentTarget && // Not to handle `onTransitionEnd` on child DOM nodes
      _this.outerModal.current && _this.outerModal.current.offsetWidth && _this.outerModal.current.offsetHeight && _this.beingOpen) {
        _this.focusButton(evt.currentTarget);

        _this.beingOpen = false;
      }
    });

    return _this;
  }

  _createClass(Modal, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (!prevProps.open && this.props.open) {
        this.beingOpen = true;
      } else if (prevProps.open && !this.props.open) {
        this.beingOpen = false;
      }

      (0, _toggleClass.default)(document.body, "".concat(prefix, "--body--with-modal-open"), this.props.open);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      (0, _toggleClass.default)(document.body, "".concat(prefix, "--body--with-modal-open"), false);
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      (0, _toggleClass.default)(document.body, "".concat(prefix, "--body--with-modal-open"), this.props.open);

      if (!this.props.open) {
        return;
      }

      this.focusButton(this.innerModal.current);
    }
  }, {
    key: "render",
    value: function render() {
      var _classNames, _classNames3;

      var _this$props2 = this.props,
          modalHeading = _this$props2.modalHeading,
          modalLabel = _this$props2.modalLabel,
          modalAriaLabel = _this$props2.modalAriaLabel,
          passiveModal = _this$props2.passiveModal,
          hasForm = _this$props2.hasForm,
          secondaryButtonText = _this$props2.secondaryButtonText,
          primaryButtonText = _this$props2.primaryButtonText,
          open = _this$props2.open,
          onRequestClose = _this$props2.onRequestClose,
          onRequestSubmit = _this$props2.onRequestSubmit,
          onSecondarySubmit = _this$props2.onSecondarySubmit,
          iconDescription = _this$props2.iconDescription,
          primaryButtonDisabled = _this$props2.primaryButtonDisabled,
          danger = _this$props2.danger,
          selectorPrimaryFocus = _this$props2.selectorPrimaryFocus,
          selectorsFloatingMenus = _this$props2.selectorsFloatingMenus,
          shouldSubmitOnEnter = _this$props2.shouldSubmitOnEnter,
          size = _this$props2.size,
          hasScrollingContent = _this$props2.hasScrollingContent,
          other = _objectWithoutProperties(_this$props2, ["modalHeading", "modalLabel", "modalAriaLabel", "passiveModal", "hasForm", "secondaryButtonText", "primaryButtonText", "open", "onRequestClose", "onRequestSubmit", "onSecondarySubmit", "iconDescription", "primaryButtonDisabled", "danger", "selectorPrimaryFocus", "selectorsFloatingMenus", "shouldSubmitOnEnter", "size", "hasScrollingContent"]);

      var onSecondaryButtonClick = onSecondarySubmit ? onSecondarySubmit : onRequestClose;
      var modalClasses = (0, _classnames.default)((_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--modal"), true), _defineProperty(_classNames, "".concat(prefix, "--modal-tall"), !passiveModal), _defineProperty(_classNames, 'is-visible', open), _defineProperty(_classNames, "".concat(prefix, "--modal--danger"), this.props.danger), _defineProperty(_classNames, this.props.className, this.props.className), _classNames));
      var containerClasses = (0, _classnames.default)("".concat(prefix, "--modal-container"), _defineProperty({}, "".concat(prefix, "--modal-container--").concat(size), size));
      var contentClasses = (0, _classnames.default)("".concat(prefix, "--modal-content"), (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--modal-content--with-form"), hasForm), _defineProperty(_classNames3, "".concat(prefix, "--modal-scroll-content"), hasScrollingContent), _classNames3));

      var modalButton = _react.default.createElement("button", {
        className: "".concat(prefix, "--modal-close"),
        type: "button",
        onClick: onRequestClose,
        title: iconDescription,
        "aria-label": iconDescription,
        ref: this.button
      }, _react.default.createElement(_iconsReact.Close20, {
        "aria-label": iconDescription,
        className: "".concat(prefix, "--modal-close__icon")
      }));

      var ariaLabel = modalLabel || this.props['aria-label'] || modalAriaLabel || modalHeading;
      var getAriaLabelledBy = modalLabel ? this.modalLabelId : this.modalHeadingId;
      var hasScrollingContentProps = hasScrollingContent ? {
        tabIndex: 0,
        role: 'region',
        'aria-label': ariaLabel,
        'aria-labelledby': getAriaLabelledBy
      } : {};

      var modalBody = _react.default.createElement("div", {
        ref: this.innerModal,
        role: "dialog",
        className: containerClasses,
        "aria-label": ariaLabel,
        "aria-modal": "true",
        tabIndex: "-1"
      }, _react.default.createElement("div", {
        className: "".concat(prefix, "--modal-header")
      }, passiveModal && modalButton, modalLabel && _react.default.createElement("h2", {
        id: this.modalLabelId,
        className: "".concat(prefix, "--modal-header__label")
      }, modalLabel), _react.default.createElement("h3", {
        id: this.modalHeadingId,
        className: "".concat(prefix, "--modal-header__heading")
      }, modalHeading), !passiveModal && modalButton), _react.default.createElement("div", _extends({
        className: contentClasses
      }, hasScrollingContentProps, {
        "aria-labelledby": getAriaLabelledBy
      }), this.props.children), hasScrollingContent && _react.default.createElement("div", {
        className: "".concat(prefix, "--modal-content--overflow-indicator")
      }), !passiveModal && _react.default.createElement("div", {
        className: "".concat(prefix, "--modal-footer")
      }, _react.default.createElement(_Button.default, {
        kind: "secondary",
        onClick: onSecondaryButtonClick
      }, secondaryButtonText), _react.default.createElement(_Button.default, {
        kind: danger ? 'danger' : 'primary',
        disabled: primaryButtonDisabled,
        onClick: onRequestSubmit,
        inputref: this.button
      }, primaryButtonText)));

      return _react.default.createElement("div", _extends({}, other, {
        onKeyDown: this.handleKeyDown,
        onMouseDown: this.handleMousedown,
        onBlur: this.handleBlur,
        className: modalClasses,
        role: "presentation",
        onTransitionEnd: this.props.open ? this.handleTransitionEnd : undefined,
        ref: this.outerModal
      }), _react.default.createElement("span", {
        ref: this.startTrap,
        tabIndex: "0",
        role: "link",
        className: "".concat(prefix, "--visually-hidden")
      }, "Focus sentinel"), modalBody, _react.default.createElement("span", {
        ref: this.endTrap,
        tabIndex: "0",
        role: "link",
        className: "".concat(prefix, "--visually-hidden")
      }, "Focus sentinel"));
    }
  }]);

  return Modal;
}(_react.Component);

exports.default = Modal;

_defineProperty(Modal, "propTypes", _defineProperty({
  /**
   * Provide the contents of your Modal
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the modal root node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the modal should be button-less
   */
  passiveModal: _propTypes.default.bool,

  /**
   * Provide whether the modal content has a form element.
   * If `true` is used here, non-form child content should have `bx--modal-content__regular-content` class.
   */
  hasForm: _propTypes.default.bool,

  /**
   * Specify a handler for closing modal.
   * The handler should care of closing modal, e.g. changing `open` prop.
   */
  onRequestClose: _propTypes.default.func,

  /**
   * Specify the DOM element ID of the top-level node.
   */
  id: _propTypes.default.string,

  /**
   * Specify the content of the modal header title.
   */
  modalHeading: _propTypes.default.node,

  /**
   * Specify the content of the modal header label.
   */
  modalLabel: _propTypes.default.node,

  /**
   * Specify a label to be read by screen readers on the modal root node
   */
  modalAriaLabel: _propTypes.default.string,

  /**
   * Specify the text for the secondary button
   */
  secondaryButtonText: _propTypes.default.string,

  /**
   * Specify the text for the primary button
   */
  primaryButtonText: _propTypes.default.string,

  /**
   * Specify whether the Modal is currently open
   */
  open: _propTypes.default.bool,

  /**
   * Specify a handler for "submitting" modal.
   * The handler should care of closing modal, e.g. changing `open` prop, if necessary.
   */
  onRequestSubmit: _propTypes.default.func,

  /**
   * Specify a handler for keypresses.
   */
  onKeyDown: _propTypes.default.func,

  /**
   * Provide a description for "close" icon that can be read by screen readers
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify whether the Button should be disabled, or not
   */
  primaryButtonDisabled: _propTypes.default.bool,

  /**
   * Specify a handler for the secondary button.
   * Useful if separate handler from `onRequestClose` is desirable
   */
  onSecondarySubmit: _propTypes.default.func,

  /**
   * Specify whether the Modal is for dangerous actions
   */
  danger: _propTypes.default.bool,

  /**
   * Specify if Enter key should be used as "submit" action
   */
  shouldSubmitOnEnter: _propTypes.default.bool,

  /**
   * Specify CSS selectors that match DOM elements working as floating menus.
   * Focusing on those elements won't trigger "focus-wrap" behavior
   */
  selectorsFloatingMenus: _propTypes.default.arrayOf(_propTypes.default.string),

  /**
   * Specify a CSS selector that matches the DOM element that should
   * be focused when the Modal opens
   */
  selectorPrimaryFocus: _propTypes.default.string,

  /**
   * Specify the size variant.
   */
  size: _propTypes.default.oneOf(['xs', 'sm', 'lg']),

  /**
   * Deprecated; Used for advanced focus-wrapping feature using 3rd party library,
   * but it's now achieved without a 3rd party library.
   */
  focusTrap: (0, _deprecate.default)(_propTypes.default.bool, "\nThe prop `focusTrap` for Modal has been deprecated, as the feature of `focusTrap` runs by default."),

  /**
   * Specify whether the modal contains scrolling content
   */
  hasScrollingContent: _propTypes.default.bool
}, 'aria-label', (0, _requiredIfGivenPropExists.default)('hasScrollingContent', _propTypes.default.string)));

_defineProperty(Modal, "defaultProps", {
  onRequestClose: function onRequestClose() {},
  onRequestSubmit: function onRequestSubmit() {},
  primaryButtonDisabled: false,
  onKeyDown: function onKeyDown() {},
  passiveModal: false,
  iconDescription: 'close the modal',
  modalHeading: '',
  modalLabel: '',
  selectorPrimaryFocus: '[data-modal-primary-focus]',
  hasScrollingContent: false
});