"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMessageBearingEntity = isMessageBearingEntity;
exports.isMetadataBearing = isMetadataBearing;
exports.hasDisplayName = hasDisplayName;
exports.isMetadataBearingByReference = isMetadataBearingByReference;
exports.isMarkdownResponse = isMarkdownResponse;
exports.isReactResponse = isReactResponse;
exports.isMixedResponse = isMixedResponse;
exports.isRawResponse = isRawResponse;

var _types = require("../util/types");

var _table = require("../webapp/models/table");

var _react = require("react");

/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function isMessageBearingEntity(entity) {
  return entity.message !== undefined;
}

function isMetadataBearing(spec) {
  const meta = spec;
  return meta !== undefined && meta.metadata !== undefined && meta.metadata.name !== undefined;
}

function hasDisplayName(resource) {
  const res = resource;
  return isMetadataBearing(resource) && res.spec !== undefined && typeof res.spec.displayName === 'string';
}

function isMetadataBearingByReference(spec) {
  const ref = spec;
  return ref !== undefined && ref.resource !== undefined && isMetadataBearing(ref.resource);
}

function isMarkdownResponse(entity) {
  const md = entity;
  return md && typeof md.content === 'string' && md.contentType === 'text/markdown';
}

function isReactResponse(entity) {
  const response = entity;
  return response && response.react && (0, _react.isValidElement)(response.react);
}

function isMixedResponse(response) {
  return Array.isArray(response) && response.length > 0 && (typeof response[0] === 'string' || (0, _table.isTable)(response[0]) || (0, _types.isHTML)(response[0]));
}

function isRawResponse(entity) {
  const raw = entity;
  return raw.mode === 'raw' && raw.content !== undefined;
}