"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTable = isTable;
exports.Icon = exports.Table = exports.TableStyle = exports.Cell = exports.Row = void 0;

/*
 * Copyright 2019-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class Row {
  constructor(row) {
    Object.assign(this, row);
  }

}

exports.Row = Row;

class Cell {
  constructor(cell) {
    Object.assign(this, cell);
  }

}

exports.Cell = Cell;
var TableStyle;
exports.TableStyle = TableStyle;

(function (TableStyle) {
  TableStyle[TableStyle["Light"] = 0] = "Light";
  TableStyle[TableStyle["Medium"] = 1] = "Medium";
  TableStyle[TableStyle["Heavy"] = 2] = "Heavy";
})(TableStyle || (exports.TableStyle = TableStyle = {}));

class Table {
  constructor(table) {
    Object.assign(this, table);
  }

}

exports.Table = Table;

function isTable(model) {
  return model !== undefined && (model instanceof Table || model.body !== undefined && Array.isArray(model.body));
}

class Icon {
  constructor(icon) {
    Object.assign(this, icon);
  }

}

exports.Icon = Icon;