/*
 * Copyright 2017-19 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
export function isStringResponse(response) {
    return response === undefined || typeof response === 'string';
}
const enumerators = [];
/** A plugin has offered a tab completion Enumerator */
export function registerEnumerator(enumerator, priority = 0) {
    enumerators.push({ enumerator, priority });
}
/**
 * Consult each registered enumerator to see what it has to offer in
 * the way of completions. Pick the one with highest priority, or the
 * first to register in the case of a tie-breaker.
 *
 */
export function applyEnumerator(tab, commandLine, spec) {
    return __awaiter(this, void 0, void 0, function* () {
        // this is a list of all offered completions, paired with the
        // priority of the registered enumerator
        const lists = (yield Promise.all(enumerators.map((_) => __awaiter(this, void 0, void 0, function* () {
            return ({
                response: yield _.enumerator(tab, commandLine, spec),
                priority: _.priority
            });
        })))).filter(_ => _.response && _.response.length > 0);
        if (lists.length === 0) {
            // no enumerators had anything to suggest
        }
        else if (lists.length === 1) {
            // exactly one enumerator had something to suggest
            return lists[0].response;
        }
        else {
            // in this case, more than one enumerator had something to
            // suggest. pick the one with highest priority, or the first to
            // register
            const bestList = lists.slice(1).reduce((best, list) => {
                if (best.priority < list.priority) {
                    return list;
                }
                else {
                    return best;
                }
            }, lists[0]);
            return bestList.response;
        }
    });
}
//# sourceMappingURL=tab-completion.js.map