"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.doGet = void 0;

var _core = require("@kui-shell/core");

var _flags = _interopRequireDefault(require("./flags"));

var _exec = require("./exec");

var _commandPrefix = _interopRequireDefault(require("../command-prefix"));

var _formatTable = require("../../lib/view/formatTable");

var _help = require("../../lib/util/help");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const doGet = command => args => __awaiter(void 0, void 0, void 0, function* () {
  if ((0, _help.isUsage)(args)) {
    return (0, _help.doHelp)(command, args);
  } else {
    // first, we do the raw exec of the given command
    const response = yield (0, _exec.exec)(args, undefined, command);
    const {
      content: {
        stderr,
        stdout
      }
    } = response;
    const table = yield (0, _formatTable.stringToTable)(stdout, stderr, args, command, 'explain', 'api-resources');

    if ((0, _core.isTable)(table)) {
      table.body.forEach(_ => {
        const name = _.attributes[3] && _.attributes[3].value || _.name;
        _.onclick = `${command} explain ${name}`;
      });
      table.body.sort((a, b) => a.name.localeCompare(b.name));
    }

    return table;
  }
});

exports.doGet = doGet;

var _default = registrar => {
  registrar.listen(`/${_commandPrefix.default}/kubectl/api-resources`, doGet('kubectl'), _flags.default);
  registrar.listen(`/${_commandPrefix.default}/k/api-resources`, doGet('kubectl'), _flags.default);
};

exports.default = _default;