"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _trafficLight = _interopRequireDefault(require("../model/traffic-light"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2018-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Decorate certain values specially
 *
 */
var _default = {
  // helm lifecycle
  UNKNOWN: '',
  DEPLOYED: _trafficLight.default.Green,
  DELETED: '',
  SUPERSEDED: _trafficLight.default.Yellow,
  FAILED: _trafficLight.default.Red,
  DELETING: _trafficLight.default.Yellow,
  // kui manufactured; see formatTable.ts withNotFounds()
  Offline: _trafficLight.default.Red,
  // pod lifecycle
  'Init:0/1': _trafficLight.default.Yellow,
  PodScheduled: _trafficLight.default.Yellow,
  PodInitializing: _trafficLight.default.Yellow,
  Initialized: _trafficLight.default.Yellow,
  Terminating: _trafficLight.default.Yellow,
  ImagePullBackOff: _trafficLight.default.Red,
  ErrImagePull: _trafficLight.default.Red,
  Error: _trafficLight.default.Red,
  // kube lifecycle
  CrashLoopBackOff: _trafficLight.default.Red,
  Failed: _trafficLight.default.Red,
  Running: _trafficLight.default.Green,
  Pending: _trafficLight.default.Yellow,
  Succeeded: _trafficLight.default.Gray,
  Completed: _trafficLight.default.Gray,
  Unknown: '',
  // AWS events
  Ready: _trafficLight.default.Green,
  ProvisionedSuccessfully: _trafficLight.default.Green,
  // kube events
  Active: _trafficLight.default.Green,
  Online: _trafficLight.default.Green,
  NodeReady: _trafficLight.default.Green,
  Pulled: _trafficLight.default.Green,
  Rebooted: _trafficLight.default.Green,
  Started: _trafficLight.default.Green,
  Created: _trafficLight.default.Green,
  Scheduled: _trafficLight.default.Green,
  SuccessfulCreate: _trafficLight.default.Green,
  SuccessfulMountVol: _trafficLight.default.Green,
  ContainerCreating: _trafficLight.default.Yellow,
  Starting: _trafficLight.default.Yellow,
  NodeNotReady: _trafficLight.default.Yellow,
  Killing: _trafficLight.default.Red,
  Deleting: _trafficLight.default.Red,
  Pulling: _trafficLight.default.Yellow,
  BackOff: _trafficLight.default.Yellow,
  Unhealthy: _trafficLight.default.Red,
  FailedScheduling: _trafficLight.default.Red,
  FailedKillPod: _trafficLight.default.Red
};
exports.default = _default;