/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { eventChannelUnsafe } from '@kui-shell/core';
import flags from './flags';
import { doExecWithPty } from './exec';
import commandPrefix from '../command-prefix';
const kubectlConfigChangeChannel = '/kubectl/config/change';
const mutators = [
    'delete-cluster',
    'delete-context',
    'rename-context',
    'set',
    'set-cluster',
    'set-context',
    'set-credentials',
    'unset',
    'use-context'
];
export function emitKubectlConfigChangeEvent(args) {
    eventChannelUnsafe.emit(kubectlConfigChangeChannel, args);
}
export function onKubectlConfigChangeEvents(handler) {
    eventChannelUnsafe.on(kubectlConfigChangeChannel, handler);
}
export function offKubectlConfigChangeEvents(handler) {
    eventChannelUnsafe.off(kubectlConfigChangeChannel, handler);
}
/**
 * Here, we conservatively broadcoast that the kubectl config *may*
 * have changed.
 *
 */
function doConfig(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield doExecWithPty(args);
        emitKubectlConfigChangeEvent(args);
        return response;
    });
}
export function register(registrar, cmd) {
    mutators.forEach(verb => {
        registrar.listen(`/${commandPrefix}/${cmd}/config/${verb}`, doConfig, flags);
    });
}
/**
 * Register the commands
 *
 */
export default (registrar) => {
    register(registrar, 'kubectl');
    register(registrar, 'k');
};
//# sourceMappingURL=config.js.map