/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, defaultModeForGet, createNS, allocateNS, deleteNS, singletonTablesHaveTitle, waitTillNone } from '@kui-shell/plugin-kubectl/tests/lib/k8s/utils';
import * as assert from 'assert';
import { dirname } from 'path';
const ROOT = dirname(require.resolve('@kui-shell/plugin-kubectl/tests/package.json'));
const ns = createNS();
const inNamespace = `-n ${ns}`;
describe(`kubectl deployment ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    const createIt = () => {
        it('should create deployment from local file', () => __awaiter(this, void 0, void 0, function* () {
            try {
                const selector = yield CLI.command(`kubectl create -f ${ROOT}/data/k8s/deployment.yaml ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('myapp') }));
                /* const selectorPrefix = selector.replace(Selectors.BY_NAME('myapp'), '')
        
                await this.app.client
                  .getText(`${selectorPrefix} .result-table-title`)
                  .then(titles => assert.ok(titles.length === 2 && titles[0] === 'DEPLOYMENT' && titles[1] === 'PODS')) */
                yield waitForGreen(this.app, selector);
                yield this.app.client.click(`${selector} [data-value="myapp"].clickable`);
                yield SidecarExpect.open(this.app)
                    .then(SidecarExpect.mode(defaultModeForGet))
                    .then(SidecarExpect.showing('myapp', undefined, undefined, ns));
            }
            catch (err) {
                return Common.oops(this)(err);
            }
        }));
    };
    const listIt = () => {
        it('should list deployments', () => __awaiter(this, void 0, void 0, function* () {
            try {
                const selector = yield CLI.command(`kubectl get deployment ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('myapp') }));
                yield this.app.client.click(`${selector} [data-value="myapp"].clickable`);
                const selectorPrefix = selector.replace(Selectors.BY_NAME('myapp'), '');
                if (singletonTablesHaveTitle) {
                    yield this.app.client
                        .getText(`${selectorPrefix} .result-table-title`)
                        .then((title) => assert.ok(title === 'DEPLOYMENT'));
                }
                yield SidecarExpect.open(this.app)
                    .then(SidecarExpect.mode(defaultModeForGet))
                    .then(SidecarExpect.showing('myapp', undefined, undefined, ns))
                    .then(() => this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON_SELECTED('summary')))
                    .then(() => this.app)
                    .then(SidecarExpect.yaml({ Name: 'myapp' }))
                    .then(() => new Promise(resolve => setTimeout(resolve, 1000)))
                    .then(() => this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('pods')))
                    .then(() => this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('pods')))
                    .then(() => this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON_SELECTED('pods')))
                    .then(() => this.app.client.waitForExist(`${Selectors.SIDECAR_TAB_CONTENT} .bx--data-table`))
                    .then(() => __awaiter(this, void 0, void 0, function* () {
                    if (singletonTablesHaveTitle) {
                        const actualTitle = yield this.app.client.getText(`${Selectors.SIDECAR_CUSTOM_CONTENT} .result-table-title`);
                        assert.strictEqual(actualTitle, 'PODS');
                    }
                }));
            }
            catch (err) {
                return Common.oops(this)(err);
            }
        }));
    };
    const getPods = () => {
        it('should list pods in deployment, then navigate using Show Owner Reference button', () => __awaiter(this, void 0, void 0, function* () {
            try {
                const selector = yield CLI.command(`kubectl get pod -lapp=drone-app ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.LIST_RESULT_FIRST }));
                yield this.app.client.click(selector);
                yield SidecarExpect.open(this.app)
                    .then(SidecarExpect.showing('myapp', undefined, undefined, ns))
                    .then(SidecarExpect.button({ mode: 'ownerReference', label: 'Show Owner Reference' }));
                yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('ownerReference'));
                yield SidecarExpect.open(this.app)
                    .then(SidecarExpect.kind('ReplicaSet'))
                    .then(SidecarExpect.button({ mode: 'ownerReference', label: 'Show Owner Reference' }));
                yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('ownerReference'));
                yield SidecarExpect.open(this.app).then(SidecarExpect.kind('Deployment'));
            }
            catch (err) {
                return Common.oops(this, true)(err);
            }
        }));
    };
    const deleteItByName = () => {
        it('should delete the deployment by name', () => {
            return CLI.command(`kubectl delete deployment myapp ${inNamespace}`, this.app)
                .then(ReplExpect.okWithAny)
                .then(() => waitTillNone('deployment', undefined, 'myapp', undefined, inNamespace))
                .catch(Common.oops(this));
        });
    };
    const deleteItByClickingOnButton = () => {
        it('should delete the deployment by clicking on the sidecar delete button', () => __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('delete'));
                yield this.app.client.waitForExist('#confirm-dialog');
                yield this.app.client.click('#confirm-dialog .bx--btn--danger');
                yield waitTillNone('deployment', undefined, 'myapp', undefined, inNamespace);
            }
            catch (err) {
                return Common.oops(this)(err);
            }
        }));
    };
    //
    // here start the tests
    //
    allocateNS(this, ns);
    createIt();
    listIt();
    getPods();
    deleteItByName();
    createIt();
    deleteItByClickingOnButton();
    deleteNS(this, ns);
});
//# sourceMappingURL=deployment.js.map