import { Arguments, Table, RawResponse } from '@kui-shell/core';
import { KubeOptions } from '@kui-shell/plugin-kubectl';
export declare function getNodeData(args: Arguments<KubeOptions>, onlySchedulable?: boolean, forNode?: string): Promise<Table>;
interface Overheads {
    cpuOverhead: number;
    memOverhead: number;
    cpuCapacity: number;
    memCapacity: number;
}
export declare function getSystemOverhead(args: Arguments<KubeOptions>, forNode: string, onlySchedulable?: boolean): Promise<Overheads>;
/**
 * Allows for `kubectl top node --summary`
 *
 */
export interface NodeOptions extends KubeOptions {
    summary?: boolean;
}
/**
 * Summary of resource consumption, averaged across nodes.
 *
 */
export interface NodeSummary {
    cpuFrac: number;
    memFrac: number;
}
export declare function strip(args: Arguments, flag: string, nargs?: number): void;
/**
 * Command handler for `kubectl top node` (overrides built-in functionality)
 *
 */
export declare function topNode(args: Arguments<NodeOptions>, top: (args: Arguments<KubeOptions>) => Promise<Table>): Promise<RawResponse<NodeSummary> | Table>;
export {};
