"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const clear = ({
  tab
}) => {
  if (!(0, _core.isHeadless)()) {
    setTimeout(() => {
      _core.eventChannelUnsafe.emit(`/terminal/clear/${(0, _core.getTabId)(tab)}`);

      _core.eventChannelUnsafe.emit(`/close/views/${(0, _core.getTabId)(tab)}`);
    });
  }

  return true;
};
/**
 * This plugin introduces the /clear command, which clear the consoles
 *
 */


var _default = registrar => {
  registrar.listen('/clear', clear);
};

exports.default = _default;