"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isFocusable = isFocusable;
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _fs = require("@kui-shell/plugin-bash-like/fs");

var _core = require("@kui-shell/core");

var _Eval = _interopRequireDefault(require("./Eval"));

var _Editor = _interopRequireDefault(require("./Editor"));

var _Table = _interopRequireDefault(require("./Table"));

var _Markdown = _interopRequireDefault(require("./Markdown"));

var _HTMLString = _interopRequireDefault(require("./HTMLString"));

var _HTMLDom = _interopRequireDefault(require("./Scalar/HTMLDom"));

var _ = require("../../");

var _RadioTable = _interopRequireDefault(require("../spi/RadioTable"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class KuiMMRContent extends React.Component {
  shouldComponentUpdate(nextProps) {
    return nextProps.isActive && (!this.state || !this.state.isRendered);
  }

  componentDidUpdate() {
    if (this.props.isActive) {
      this.setState({
        isRendered: true
      });
    }
  }

  render() {
    if (!this.props.isActive) {
      return React.createElement(React.Fragment, null);
    }

    const {
      tab,
      mode,
      response,
      willUpdateToolbar
    } = this.props;

    if ((0, _core.isStringWithOptionalContentType)(mode)) {
      if (mode.contentType === 'text/html') {
        return React.createElement(_HTMLString.default, {
          content: mode.content
        });
      } else if (mode.contentType === 'text/markdown') {
        return React.createElement(_Markdown.default, {
          tab: tab,
          repl: tab.REPL,
          fullpath: (0, _fs.isFile)(response) ? response.spec.fullpath : undefined,
          source: mode.content
        });
      } else {
        return React.createElement(_Editor.default, {
          content: mode,
          readOnly: false,
          willUpdateToolbar: willUpdateToolbar,
          response: response,
          repl: tab.REPL,
          tabUUID: (0, _core.getPrimaryTabId)(tab)
        });
      }
    } else if ((0, _core.isCommandStringContent)(mode)) {
      return React.createElement(_Eval.default, Object.assign({}, this.props, {
        command: mode.contentFrom,
        contentType: mode.contentType
      }));
    } else if ((0, _core.isFunctionContent)(mode)) {
      return React.createElement(_Eval.default, Object.assign({}, this.props, {
        command: mode.content
      }));
    } else if ((0, _core.isScalarContent)(mode)) {
      if ((0, _core.isReactProvider)(mode)) {
        return mode.react({
          willUpdateToolbar
        });
      } else if ((0, _core.isRadioTable)(mode.content)) {
        const radioTable = mode.content; // ^^^ Notes: Even though isRadioTable(mode.content) checks the type of mode.content,
        // RadioTableSpi in KuiContext.Consumer doesn't know the type of mode.content is RadioTable and throws error
        // so we have to re-assign mode.content to work around this typescript compile error

        return React.createElement(_.KuiContext.Consumer, null, config => React.createElement(_RadioTable.default, {
          table: radioTable,
          title: !config.disableTableTitle
        }));
      } else if ((0, _core.isTable)(mode.content)) {
        return (0, _Table.default)(tab, tab.REPL, mode.content, false); // ^^^ Notes: typescript doesn't like this, and i don't know why:
        // "is not assignable to type IntrinsicAttributes..."
        // <PaginatedTable {...props} />
      } else if ((0, _core.isHTML)(mode.content)) {
        return React.createElement(_HTMLDom.default, {
          content: mode.content
        });
      } else {
        console.error('Unsupported scalar content', mode);
      }
    }

    return React.createElement("div", {
      className: "oops"
    }, "Unsupported content");
  }

}

exports.default = KuiMMRContent;

function isFocusable(node) {
  return typeof node.doFocus === 'function';
}