"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _TopNavSidecar = _interopRequireDefault(require("./TopNavSidecar"));

var _LeftNavSidecar = _interopRequireDefault(require("./LeftNavSidecar"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class ComboSidecar extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      tab: undefined,
      responseType: undefined
    };
    const onResponse = this.onResponse.bind(this);

    _core.eventBus.onMultiModalResponse(props.uuid, onResponse);

    _core.eventBus.onNavResponse(props.uuid, onResponse); // this.cleaners.push(() => eventChannelUnsafe.off(channel1, onResponse))

  }

  componentDidCatch(error, errorInfo) {
    console.error(error, errorInfo);
  }

  onResponse(event) {
    this.setState({
      tab: event.tab,
      responseType: event.responseType
    });
  }

  onClose() {
    // when closing, tell our owner that they can have focus back
    if (this.props.willLoseFocus) {
      this.props.willLoseFocus();
    }
  }

  render() {
    const isLeftNav = this.state.responseType && this.state.responseType === 'NavResponse';
    return React.createElement("div", {
      className: "kui--full-height"
    }, React.createElement("div", {
      className: 'kui--full-height' + (isLeftNav || this.state.responseType === undefined ? ' hide' : '')
    }, React.createElement(_TopNavSidecar.default, Object.assign({}, this.props, {
      onClose: this.onClose.bind(this)
    }))), React.createElement("div", {
      className: 'kui--full-height' + (!isLeftNav ? ' hide' : '')
    }, React.createElement(_LeftNavSidecar.default, Object.assign({}, this.props, {
      onClose: this.onClose.bind(this)
    }))));
  }

}

exports.default = ComboSidecar;