"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _carbonComponentsReact = require("carbon-components-react");

var _2 = require("..");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class CarbonBreadcrumb extends React.PureComponent {
  render() {
    const breadcrumbs = this.props.breadcrumbs;
    const currentPageIdx = (0, _2.getCurrentPageIdx)(this.props);
    return React.createElement(_carbonComponentsReact.Breadcrumb, {
      noTrailingSlash: breadcrumbs.length >= 1
    }, breadcrumbs.map((_, idx) => {
      const onClick = _.command && (() => this.props.repl.pexec(_.command));

      return React.createElement(_carbonComponentsReact.BreadcrumbItem, {
        href: onClick ? '#' : undefined,
        key: idx,
        className: [_.className, _.deemphasize && 'kui--secondary-breadcrumb'].filter(_ => _).join(' '),
        isCurrentPage: idx === currentPageIdx,
        onClick: onClick
      }, _.command ? React.createElement("a", {
        href: "#"
      }, _.label) : React.createElement("span", null, _.label));
    }));
  }

}

exports.default = CarbonBreadcrumb;